/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0010J\u0006\u0010\u0018\u001a\u00020\u0019R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/DirtBuilder;", "", "()V", "<set-?>", "", "isEverythingDirty", "()Z", "scopesByVcs", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeImpl;", "addDirtyFiles", "vcsRoot", "Lcom/intellij/openapi/vcs/VcsRoot;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "dirs", "buildScopes", "", "project", "Lcom/intellij/openapi/project/Project;", "isFileDirty", "filePath", "markEverythingDirty", "", "intellij.platform.vcs.impl"})
public final class DirtBuilder {
    private final Map<AbstractVcs, VcsDirtyScopeImpl> scopesByVcs;
    private boolean isEverythingDirty;

    public final boolean isEverythingDirty() {
        return this.isEverythingDirty;
    }

    public final void markEverythingDirty() {
        this.isEverythingDirty = true;
        this.scopesByVcs.clear();
    }

    public final boolean addDirtyFiles(@NotNull VcsRoot vcsRoot, @NotNull Collection<? extends FilePath> files, @NotNull Collection<? extends FilePath> dirs) {
        if (this.isEverythingDirty) {
            return true;
        }
        AbstractVcs vcs = vcsRoot.getVcs();
        VirtualFile root = vcsRoot.getPath();
        if (vcs != null) {
            VcsDirtyScopeImpl scope2 = this.scopesByVcs.computeIfAbsent(vcs, new Function<AbstractVcs, VcsDirtyScopeImpl>(this){
                final /* synthetic */ DirtBuilder this$0;

                @NotNull
                public final VcsDirtyScopeImpl apply(@NotNull AbstractVcs it) {
                    return new VcsDirtyScopeImpl(it, this.this$0.isEverythingDirty());
                }
                {
                    this.this$0 = dirtBuilder;
                }
            });
            for (FilePath filePath : files) {
                scope2.addDirtyPathFast(root, filePath, false);
            }
            for (FilePath filePath : dirs) {
                scope2.addDirtyPathFast(root, filePath, true);
            }
        }
        Map<AbstractVcs, VcsDirtyScopeImpl> map2 = this.scopesByVcs;
        boolean bl = false;
        return !map2.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsDirtyScopeImpl> buildScopes(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        VcsDirtyScopeImpl scope2;
        Collection<VcsDirtyScopeImpl> scopes = null;
        if (this.isEverythingDirty) {
            boolean bl = false;
            Map allScopes = new LinkedHashMap();
            for (VcsRoot root : ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()) {
                AbstractVcs vcs = root.getVcs();
                VirtualFile path2 = root.getPath();
                if (vcs == null) continue;
                scope2 = (VcsDirtyScopeImpl)((Object)allScopes.computeIfAbsent(vcs, (Function)new Function<AbstractVcs, VcsDirtyScopeImpl>(this){
                    final /* synthetic */ DirtBuilder this$0;

                    @NotNull
                    public final VcsDirtyScopeImpl apply(@NotNull AbstractVcs it) {
                        return new VcsDirtyScopeImpl(it, this.this$0.isEverythingDirty());
                    }
                    {
                        this.this$0 = dirtBuilder;
                    }
                }));
                scope2.addDirtyPathFast(path2, VcsUtil.getFilePath((VirtualFile)path2), true);
            }
            scopes = allScopes.values();
        } else {
            scopes = this.scopesByVcs.values();
        }
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            scope2 = (VcsDirtyScopeImpl)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VcsDirtyScopeImpl vcsDirtyScopeImpl = it.pack();
            collection.add(vcsDirtyScopeImpl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFileDirty(@NotNull FilePath filePath) {
        VcsDirtyScopeImpl it;
        if (this.isEverythingDirty) return true;
        Iterable $this$any$iv = this.scopesByVcs.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VcsDirtyScopeImpl)((Object)element$iv);
            boolean bl = false;
        } while (!it.belongsTo(filePath));
        return true;
    }

    public DirtBuilder() {
        boolean bl = false;
        this.scopesByVcs = new LinkedHashMap();
    }

    public static final /* synthetic */ boolean access$isEverythingDirty$p(DirtBuilder $this) {
        return $this.isEverythingDirty;
    }

    public static final /* synthetic */ void access$setEverythingDirty$p(DirtBuilder $this, boolean bl) {
        $this.isEverythingDirty = bl;
    }
}

