/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vcs.changes.ChangesViewPanel;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.problems.ProblemListener;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitWorkflowManager;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import com.intellij.vcs.commit.ToggleChangesViewCommitUiActionKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewEx,
PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ChangesViewManager.class);
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState = new State();
    @Nullable
    private ChangesViewToolWindowPanel myToolWindowPanel;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        return (ChangesViewI)project.getService(ChangesViewI.class);
    }

    @NotNull
    public static ChangesViewEx getInstanceEx(@NotNull Project project) {
        return (ChangesViewEx)ChangesViewManager.getInstance(project);
    }

    public ChangesViewManager(@NotNull Project project) {
        this.myProject = project;
        ChangesViewModifier.KEY.addChangeListener((AreaInstance)project, this::refreshImmediately, (Disposable)this);
    }

    @NotNull
    private ChangesViewToolWindowPanel initToolWindowPanel() {
        if (this.myToolWindowPanel == null) {
            ChangesViewToolWindowPanel panel2 = new ChangesViewToolWindowPanel(this.myProject, this);
            Disposer.register((Disposable)this.myProject, (Disposable)panel2);
            this.myToolWindowPanel = panel2;
        }
        return this.myToolWindowPanel;
    }

    public void dispose() {
        this.myToolWindowPanel = null;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys = ContainerUtil.set((Object[])ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    @Override
    public void scheduleRefresh() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefresh();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectFile(vFile);
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectChanges(changes);
    }

    @Override
    public void updateProgressText(String text2, boolean isError) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateProgressText(text2, isError);
    }

    @Override
    public void setBusy(boolean b) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setBusy(b);
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setGrouping(groupingKey);
    }

    @Override
    public void updateCommitWorkflow() {
        boolean isNonModal = CommitWorkflowManager.getInstance(this.myProject).isNonModal();
        if (this.myToolWindowPanel != null) {
            this.myToolWindowPanel.updateCommitWorkflow(isNonModal);
        } else if (isNonModal) {
            this.initToolWindowPanel().updateCommitWorkflow(isNonModal);
        }
    }

    @Override
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        if (this.myToolWindowPanel == null) {
            return null;
        }
        return this.myToolWindowPanel.getCommitWorkflowHandler();
    }

    @Override
    public void refreshImmediately() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.refreshImmediately();
    }

    @Override
    public boolean isAllowExcludeFromCommit() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.isAllowExcludeFromCommit();
    }

    public void closeEditorPreview() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        DiffPreview diffPreview = this.myToolWindowPanel.myDiffPreview;
        if (diffPreview instanceof EditorTabPreview) {
            ((EditorTabPreview)diffPreview).closePreview();
        }
    }

    public void openEditorPreview() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.openEditorPreview();
    }

    protected ChangesViewCommitPanel createCommitPanel(@NotNull ChangesListView myView, @NotNull ChangesViewToolWindowPanel changesViewToolWindowPanel) {
        return new ChangesViewCommitPanel(myView, (JComponent)((Object)changesViewToolWindowPanel));
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(String text2, boolean isError) {
        return () -> {
            JLabel label = new JLabel(text2);
            label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label;
        };
    }

    private static class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyContentDnDTarget(@NotNull Project project, @NotNull Content content2) {
            super(project, content2);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ChangesViewToolWindowPanel panel2 = ((ChangesViewManager)ChangesViewManager.getInstance(this.myProject)).initToolWindowPanel();
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, ChangesTreeDnDSupport.getDropRootNode(panel2.myView, event), !ChangesTreeDnDSupport.isCopyAction(event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }
    }

    public static class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements ChangesViewContentManagerListener,
    Disposable {
        @NotNull
        private static final RegistryValue isToolbarHorizontalSetting = Registry.get((String)"vcs.local.changes.toolbar.horizontal");
        @NotNull
        private static final RegistryValue isEditorDiffPreview = Registry.get((String)"show.diff.preview.as.editor.tab");
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesViewManager myChangesViewManager;
        @NotNull
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final BorderLayoutPanel myMainPanel;
        @NotNull
        private final BorderLayoutPanel myContentPanel;
        @NotNull
        private final ChangesViewPanel myChangesPanel;
        @NotNull
        private final ChangesListView myView;
        @NotNull
        private final ChangesViewCommitPanelSplitter myCommitPanelSplitter;
        private ChangesViewDiffPreviewProcessor myChangeProcessor;
        private DiffPreview myDiffPreview;
        @NotNull
        private final Wrapper myProgressLabel = new Wrapper();
        @Nullable
        private ChangesViewCommitPanel myCommitPanel;
        @Nullable
        private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
        @NotNull
        private final Alarm myTreeUpdateAlarm;
        @NotNull
        private final Object myTreeUpdateIndicatorLock = new Object();
        @NotNull
        private ProgressIndicator myTreeUpdateIndicator = new EmptyProgressIndicator();
        private boolean myModelUpdateInProgress;
        private boolean myDisposed = false;

        private ChangesViewToolWindowPanel(@NotNull Project project, @NotNull ChangesViewManager changesViewManager) {
            super(false, true);
            this.myProject = project;
            this.myChangesViewManager = changesViewManager;
            final CommitWorkflowManager commitWorkflowManager = CommitWorkflowManager.getInstance(this.myProject);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myTreeUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
            this.myChangesPanel = new ChangesViewPanel(project);
            this.myView = this.myChangesPanel.getChangesView();
            this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(((ChangesViewManager)this.myChangesViewManager).myState.groupingKeys);
            this.myView.addGroupingChangeListener(e -> {
                ((ChangesViewManager)this.myChangesViewManager).myState.groupingKeys = this.myView.getGroupingSupport().getGroupingKeys();
                this.scheduleRefresh();
            });
            ChangesViewDnDSupport.install(this.myProject, this.myView, this);
            this.myChangesPanel.getToolbarActionGroup().addAll(this.createChangesToolbarActions(this.myView.getTreeExpander()));
            this.myChangesPanel.setToolbarHorizontal(commitWorkflowManager.isNonModal() && isToolbarHorizontalSetting.asBoolean());
            ChangesViewToolWindowPanel.registerShortcuts((JComponent)((Object)this));
            isToolbarHorizontalSetting.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    boolean isToolbarHorizontal = value.asBoolean() && commitWorkflowManager.isNonModal();
                    myChangesPanel.setToolbarHorizontal(isToolbarHorizontal);
                    if (myCommitPanel != null) {
                        myCommitPanel.setToolbarHorizontal(isToolbarHorizontal);
                    }
                }
            }, (Disposable)this);
            this.myCommitPanelSplitter = new ChangesViewCommitPanelSplitter(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myCommitPanelSplitter);
            this.myCommitPanelSplitter.setFirstComponent((JComponent)((Object)this.myChangesPanel));
            this.myContentPanel = new BorderLayoutPanel(){

                public Dimension getMinimumSize() {
                    return this.isMinimumSizeSet() || myChangesPanel.isToolbarHorizontal() ? super.getMinimumSize() : myChangesPanel.getToolbar().getComponent().getPreferredSize();
                }
            };
            this.myContentPanel.addToCenter((Component)((Object)this.myCommitPanelSplitter));
            this.myMainPanel = JBUI.Panels.simplePanel((Component)this.myContentPanel);
            this.setDiffPreview();
            isEditorDiffPreview.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    this.setDiffPreview();
                }
            }, (Disposable)this);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (!this.isSplitterPreview()) {
                        this.setDiffPreview(true);
                    }
                }
            }, (Disposable)this);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
            this.setContent((JComponent)this.myMainPanel.addToBottom((Component)this.myProgressLabel));
            project.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

                public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                    this.setCommitSplitOrientation();
                }
            });
            ToggleChangesViewCommitUiActionKt.isToggleCommitUi().addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (myCommitWorkflowHandler == null) {
                        return;
                    }
                    if (value.asBoolean()) {
                        myCommitWorkflowHandler.deactivate(false);
                    } else {
                        myCommitWorkflowHandler.activate();
                    }
                }
            }, (Disposable)this);
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            busConnection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> this.scheduleRefresh());
            busConnection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

                public void problemsAppeared(@NotNull VirtualFile file) {
                    this.refreshChangesViewNodeAsync(file);
                }

                public void problemsDisappeared(@NotNull VirtualFile file) {
                    this.refreshChangesViewNodeAsync(file);
                }
            });
            busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
            busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, () -> {
                if (this.myChangeProcessor != null) {
                    this.myChangeProcessor.fireDiffSettingsChanged();
                }
            });
            this.scheduleRefresh();
            this.myDiffPreview.updatePreview(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.myDisposed = true;
            this.myTreeUpdateAlarm.cancelAllRequests();
            Object object = this.myTreeUpdateIndicatorLock;
            synchronized (object) {
                this.myTreeUpdateIndicator.cancel();
            }
        }

        @Override
        public void toolWindowMappingChanged() {
            this.setDiffPreview();
        }

        private void setDiffPreview() {
            this.setDiffPreview(false);
        }

        private void setDiffPreview(boolean force) {
            boolean isEditorPreview;
            boolean bl = isEditorPreview = ChangesViewContentManagerKt.isCommitToolWindow(this.myProject) || isEditorDiffPreview.asBoolean();
            if (!force) {
                if (isEditorPreview && this.myDiffPreview instanceof EditorTabPreview) {
                    return;
                }
                if (!isEditorPreview && this.isSplitterPreview()) {
                    return;
                }
            }
            if (this.myChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myChangeProcessor);
            }
            String place = isEditorPreview ? "Default" : "ChangesView";
            this.myChangeProcessor = new ChangesViewDiffPreviewProcessor(this.myView, place);
            Disposer.register((Disposable)this, (Disposable)this.myChangeProcessor);
            this.myDiffPreview = isEditorPreview ? this.installEditorPreview(this.myChangeProcessor) : this.installSplitterPreview(this.myChangeProcessor);
            this.configurePreview();
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull ChangesViewDiffPreviewProcessor changeProcessor) {
            EditorTabPreview editorPreview = new EditorTabPreview((DiffRequestProcessor)changeProcessor){

                @Override
                protected String getCurrentName() {
                    return changeProcessor.getCurrentChangeName();
                }

                @Override
                protected boolean hasContent() {
                    return changeProcessor.getCurrentChangeName() != null;
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!((Object)((Object)myView)).equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    if (!this.isEditorPreviewAllowed()) {
                        return true;
                    }
                    return myModelUpdateInProgress;
                }
            };
            editorPreview.setEscapeHandler(() -> {
                editorPreview.closePreview();
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            });
            if (isOpenEditorDiffPreviewWithSingleClick.asBoolean()) {
                editorPreview.openWithSingleClick(this.myView);
            } else {
                editorPreview.openWithDoubleClick(this.myView);
            }
            editorPreview.installNextDiffActionOn((JComponent)this.myContentPanel);
            UIUtil.putClientProperty((JComponent)((Object)this.myView), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
            return editorPreview;
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull ChangesViewDiffPreviewProcessor changeProcessor) {
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ChangesViewManager.CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent((JComponent)this.myContentPanel);
            previewSplitter.setPreviewVisible(this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            this.myView.addSelectionListener(() -> {
                boolean fromModelRefresh = this.myModelUpdateInProgress;
                this.invokeLater(() -> previewSplitter.updatePreview(fromModelRefresh));
            }, (Disposable)changeProcessor);
            this.myMainPanel.addToCenter((Component)((Object)previewSplitter));
            Disposer.register((Disposable)changeProcessor, () -> {
                this.myMainPanel.remove((Component)((Object)previewSplitter));
                this.myMainPanel.addToCenter((Component)this.myContentPanel);
                this.myMainPanel.revalidate();
                this.myMainPanel.repaint();
            });
            return previewSplitter;
        }

        private boolean isSplitterPreview() {
            return this.myDiffPreview instanceof PreviewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }

        private void openEditorPreview() {
            if (this.isSplitterPreview()) {
                return;
            }
            if (!this.isEditorPreviewAllowed()) {
                return;
            }
            ((EditorTabPreview)this.myDiffPreview).openPreview(false);
        }

        @Nullable
        public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
            return this.myCommitWorkflowHandler;
        }

        public void updateCommitWorkflow(boolean isNonModal) {
            if (isNonModal) {
                if (this.myCommitPanel == null) {
                    this.myChangesPanel.setToolbarHorizontal(isToolbarHorizontalSetting.asBoolean());
                    this.myCommitPanel = this.myChangesViewManager.createCommitPanel(this.myView, this);
                    this.myCommitPanel.setToolbarHorizontal(isToolbarHorizontalSetting.asBoolean());
                    this.myCommitWorkflowHandler = new ChangesViewCommitWorkflowHandler(new ChangesViewCommitWorkflow(this.myProject), this.myCommitPanel);
                    if (ToggleChangesViewCommitUiActionKt.isToggleCommitUi().asBoolean()) {
                        this.myCommitWorkflowHandler.deactivate(false);
                    }
                    Disposer.register((Disposable)this, (Disposable)this.myCommitPanel);
                    this.myCommitPanelSplitter.setSecondComponent((JComponent)((Object)this.myCommitPanel));
                    this.configurePreview();
                    this.myCommitWorkflowHandler.addActivityListener(() -> this.configurePreview(), this.myCommitWorkflowHandler);
                }
            } else {
                this.myChangesPanel.setToolbarHorizontal(false);
                if (this.myCommitPanel != null) {
                    this.myCommitPanelSplitter.setSecondComponent(null);
                    Disposer.dispose((Disposable)this.myCommitPanel);
                    this.myCommitPanel = null;
                    this.myCommitWorkflowHandler = null;
                    this.configurePreview();
                }
            }
        }

        public boolean isAllowExcludeFromCommit() {
            return this.myCommitWorkflowHandler != null && this.myCommitWorkflowHandler.isActive();
        }

        private void configurePreview() {
            this.myChangeProcessor.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
        }

        private void setCommitSplitOrientation() {
            boolean hasPreviewPanel = this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN && this.isSplitterPreview();
            ToolWindow tw = Objects.requireNonNull(ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes"));
            boolean toolwindowIsHorizontal = tw.getAnchor().isHorizontal();
            this.myCommitPanelSplitter.setOrientation(hasPreviewPanel || !toolwindowIsHorizontal);
        }

        @NotNull
        private Function<ChangeNodeDecorator, ChangeNodeDecorator> getChangeDecoratorProvider() {
            return baseDecorator -> new PartialCommitChangeNodeDecorator(this.myProject, (ChangeNodeDecorator)baseDecorator, (Function0<Boolean>)((Function0)() -> this.isAllowExcludeFromCommit()));
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            return Arrays.asList(this.myChangesPanel.getToolbarActionGroup().getChildren(null));
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object data = super.getData(dataId);
            if (data != null) {
                return data;
            }
            return this.myCommitPanel != null ? this.myCommitPanel.getDataFromProviders(dataId) : null;
        }

        private static void registerShortcuts(@NotNull JComponent component) {
            EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)component);
        }

        @NotNull
        private List<AnAction> createChangesToolbarActions(@NotNull TreeExpander treeExpander) {
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            actions.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
            actions.add((AnAction)Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            DefaultActionGroup viewOptionsGroup = DefaultActionGroup.createPopupGroup(() -> VcsBundle.message((String)"action.ChangesViewToolWindowPanel.text", (Object[])new Object[0]));
            viewOptionsGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            viewOptionsGroup.add((AnAction)new ToggleShowIgnoredAction());
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.ViewOptions"));
            actions.add((AnAction)viewOptionsGroup);
            actions.add(CommonActionsManager.getInstance().createExpandAllHeaderAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add(CommonActionsManager.getInstance().createCollapseAllAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add((AnAction)Separator.getInstance());
            actions.add((AnAction)new ToggleDetailsAction());
            return actions;
        }

        private void updateProgressComponent(@Nullable Factory<? extends JComponent> progress) {
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                JComponent component = progress != null ? (JComponent)progress.create() : null;
                this.myProgressLabel.setContent(component);
                this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
            });
        }

        public void updateProgressText(String text2, boolean isError) {
            this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text2, isError));
        }

        public void setBusy(boolean b) {
            this.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
        }

        public void scheduleRefresh() {
            if (this.myDisposed) {
                return;
            }
            this.myTreeUpdateAlarm.cancelAllRequests();
            this.myTreeUpdateAlarm.addRequest(() -> this.refreshView(), 100);
        }

        public void refreshImmediately() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myTreeUpdateAlarm.cancelAllRequests();
            this.refreshView(false);
        }

        private void refreshView() {
            this.refreshView(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshView(boolean canBeCancelled) {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            Object object = this.myTreeUpdateIndicatorLock;
            synchronized (object) {
                this.myTreeUpdateIndicator.cancel();
                this.myTreeUpdateIndicator = indicator;
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> this.lambda$refreshView$15(canBeCancelled, (ProgressIndicator)indicator), (ProgressIndicator)(canBeCancelled ? indicator : null));
        }

        public void setGrouping(@NotNull String groupingKey) {
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(ContainerUtil.set((Object[])new String[]{groupingKey}));
        }

        public void selectFile(@Nullable VirtualFile vFile) {
            if (vFile == null) {
                return;
            }
            Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
            Change objectToFind = change != null ? change : vFile;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
            if (node != null) {
                TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
            }
        }

        public void selectChanges(@NotNull List<? extends Change> changes) {
            ArrayList paths = new ArrayList();
            for (Change change : changes) {
                ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
            }
            TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
        }

        public void refreshChangesViewNodeAsync(@NotNull VirtualFile file) {
            this.invokeLater(() -> this.refreshChangesViewNode(file));
        }

        private void refreshChangesViewNode(@NotNull VirtualFile file) {
            DefaultMutableTreeNode root;
            DefaultMutableTreeNode node;
            VirtualFile userObject;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            Object object = userObject = changeListManager.isUnversioned(file) ? file : changeListManager.getChange(file);
            if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
                this.myView.getModel().nodeChanged(node);
            }
        }

        private void invokeLater(Runnable runnable) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            GuiUtils.invokeLaterIfNeeded((Runnable)runnable, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
        }

        private /* synthetic */ void lambda$refreshView$15(boolean canBeCancelled, ProgressIndicator indicator) {
            if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
            List changeLists = changeListManager.getChangeListsCopy();
            List<FilePath> unversionedFiles = changeListManager.getUnversionedFilesPaths();
            TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.getGrouping()).setChangeLists(changeLists, Registry.is((String)"vcs.skip.single.default.changelist"), this.getChangeDecoratorProvider()).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(unversionedFiles);
            if (((ChangesViewManager)this.myChangesViewManager).myState.myShowIgnored) {
                treeModelBuilder.setIgnored(changeListManager.getIgnoredFilePaths(), changeListManager.isIgnoredInUpdateMode());
            }
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                if (canBeCancelled) {
                    indicator.checkCanceled();
                }
                for (ChangesViewModifier extension : ChangesViewModifier.KEY.getExtensions((AreaInstance)this.myProject)) {
                    extension.modifyTreeModelBuilder(treeModelBuilder);
                }
                DefaultTreeModel newModel = treeModelBuilder.build();
                this.myModelUpdateInProgress = true;
                try {
                    this.myView.updateModel(newModel);
                    if (this.myCommitWorkflowHandler != null) {
                        this.myCommitWorkflowHandler.synchronizeInclusion(changeLists, unversionedFiles);
                    }
                }
                finally {
                    this.myModelUpdateInProgress = false;
                }
                this.myDiffPreview.updatePreview(true);
            });
        }

        private class ToggleDetailsAction
        extends ShowDiffPreviewAction {
            private ToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ChangesViewToolWindowPanel.this.isSplitterPreview() || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                ((ChangesViewToolWindowPanel)ChangesViewToolWindowPanel.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = state;
                ChangesViewToolWindowPanel.this.myDiffPreview.setPreviewVisible(state);
                ChangesViewToolWindowPanel.this.setCommitSplitOrientation();
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return ((ChangesViewToolWindowPanel)ChangesViewToolWindowPanel.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
            }
        }

        private class ToggleShowIgnoredAction
        extends ToggleAction
        implements DumbAware {
            ToggleShowIgnoredAction() {
                super(VcsBundle.messagePointer((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return ((ChangesViewManager)((ChangesViewToolWindowPanel)ChangesViewToolWindowPanel.this).myChangesViewManager).myState.myShowIgnored;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                ((ChangesViewManager)((ChangesViewToolWindowPanel)ChangesViewToolWindowPanel.this).myChangesViewManager).myState.myShowIgnored = state;
                ChangesViewToolWindowPanel.this.refreshView();
            }
        }

        private class MyChangeListListener
        extends ChangeListAdapter {
            private MyChangeListListener() {
            }

            public void changeListsChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            public void changeListUpdateDone() {
                ChangesViewToolWindowPanel.this.setBusy(false);
                ChangesViewToolWindowPanel.this.scheduleRefresh();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewToolWindowPanel.this.myProject);
                VcsException updateException = changeListManager.getUpdateException();
                if (updateException == null) {
                    ChangesViewToolWindowPanel.this.updateProgressComponent((Factory<? extends JComponent>)changeListManager.getAdditionalUpdateInfo());
                } else {
                    ChangesViewToolWindowPanel.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
                }
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public Set<String> groupingKeys = new HashSet<String>();
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public void initTabContent(@NotNull Content content2) {
            ChangesViewManager viewManager = (ChangesViewManager)ChangesViewManager.getInstance(this.myProject);
            ChangesViewToolWindowPanel panel2 = viewManager.initToolWindowPanel();
            content2.setHelpId("ideaInterface.changes");
            content2.setComponent((JComponent)((Object)panel2));
            content2.setPreferredFocusableComponent((JComponent)((Object)panel2.myView));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return VcsBundle.getString((String)"local.changes.tab");
        }
    }

    public static class ContentPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            return ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content2) {
            content2.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.myProject, content2));
        }
    }
}

