/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChangeListManagerSerialization {
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_ESCAPED = "beforePathEscaped";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_ESCAPED = "afterPathEscaped";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_IS_DIR = "beforeDir";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_IS_DIR = "afterDir";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_CHANGE = "change";

    ChangeListManagerSerialization() {
    }

    public static void writeExternal(@NotNull Element element, @NotNull ChangeListWorker worker) {
        for (LocalChangeList list : worker.getChangeLists()) {
            element.addContent(ChangeListManagerSerialization.writeChangeList(list));
        }
    }

    public static void readExternal(@NotNull Element element, @NotNull ChangeListWorker worker) {
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, worker.getProject()));
        }
        worker.setChangeLists(ChangeListManagerSerialization.removeDuplicatedLists(lists));
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map2 = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list : lists) {
            if (list.isDefault() && hasDefault) {
                list = new LocalChangeListImpl.Builder(list).setDefault(false).build();
            }
            hasDefault |= list.isDefault();
            LocalChangeListImpl otherList = (LocalChangeListImpl)((Object)map2.get(list.getName()));
            if (otherList != null) {
                list = new LocalChangeListImpl.Builder(otherList).setChanges(ContainerUtil.union((Set)list.getChanges(), (Set)otherList.getChanges())).setDefault(list.isDefault() || otherList.isDefault()).build();
            }
            map2.put(list.getName(), list);
        }
        return map2.values();
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list) {
        Object listData;
        Element listNode = new Element(NODE_LIST);
        if (list.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list.getId());
        listNode.setAttribute(ATT_NAME, list.getName());
        String comment = list.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        if ((listData = list.getData()) instanceof ChangeListData) {
            listNode.addContent(ChangeListData.writeExternal((ChangeListData)listData));
        }
        List changes = ContainerUtil.sorted((Collection)list.getChanges(), (Comparator)new ChangeComparator());
        for (Change change : changes) {
            listNode.addContent(ChangeListManagerSerialization.writeChange(change));
        }
        return listNode;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project) {
        String id = listNode.getAttributeValue(ATT_ID);
        String name = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_NAME), (String)LocalChangeList.getDefaultName());
        String comment = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_COMMENT));
        ChangeListData data = ChangeListData.readExternal(listNode);
        boolean isDefault = ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            changes.add(ChangeListManagerSerialization.readChange(changeNode));
        }
        return new LocalChangeListImpl.Builder(project, name).setId(id).setComment(comment).setChanges(changes).setData(data).setDefault(isDefault).build();
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        Element changeNode = new Element(NODE_CHANGE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getBeforeRevision(), RevisionSide.BEFORE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getAfterRevision(), RevisionSide.AFTER);
        return changeNode;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        FakeRevision bRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.BEFORE);
        FakeRevision aRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.AFTER);
        return new Change((ContentRevision)bRev, (ContentRevision)aRev);
    }

    private static void writeContentRevision(@NotNull Element changeNode, @Nullable ContentRevision rev, @NotNull RevisionSide side) {
        if (rev == null) {
            return;
        }
        FilePath filePath = rev.getFile();
        String path2 = filePath.getPath();
        if (ChangeListManagerSerialization.hasIllegalXmlChars(path2)) {
            changeNode.setAttribute(side.getPathKey(), JDOMUtil.removeControlChars((String)path2));
            changeNode.setAttribute(side.getEscapedPathKey(), XmlStringUtil.escapeIllegalXmlChars((String)path2));
        } else {
            changeNode.setAttribute(side.getPathKey(), path2);
        }
        changeNode.setAttribute(side.getIsDirKey(), String.valueOf(filePath.isDirectory()));
    }

    @Nullable
    private static FakeRevision readContentRevision(@NotNull Element changeNode, @NotNull RevisionSide side) {
        String path2;
        String plainPath = changeNode.getAttributeValue(side.getPathKey());
        String escapedPath = changeNode.getAttributeValue(side.getEscapedPathKey());
        String string = path2 = escapedPath != null ? XmlStringUtil.unescapeIllegalXmlChars((String)escapedPath) : plainPath;
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        String value = changeNode.getAttributeValue(side.getIsDirKey());
        if (value != null) {
            boolean isDirectory = Boolean.parseBoolean(value);
            return new FakeRevision(VcsUtil.getFilePath((String)path2, (boolean)isDirectory));
        }
        return new FakeRevision(VcsUtil.getFilePath((String)path2));
    }

    private static boolean hasIllegalXmlChars(@NotNull String text2) {
        return text2.chars().anyMatch(c -> !Verifier.isXMLCharacter((int)c));
    }

    private static enum RevisionSide {
        BEFORE("beforePath", "beforePathEscaped", "beforeDir"),
        AFTER("afterPath", "afterPathEscaped", "afterDir");

        @NotNull
        private final String myPathKey;
        @NotNull
        private final String myEscapedPathKey;
        @NotNull
        private final String myIsDirKey;

        private RevisionSide(@NotNull String pathKey, String escapedPathKey, String isDirKey) {
            this.myPathKey = pathKey;
            this.myEscapedPathKey = escapedPathKey;
            this.myIsDirKey = isDirKey;
        }

        @NotNull
        public String getPathKey() {
            return this.myPathKey;
        }

        @NotNull
        String getEscapedPathKey() {
            return this.myEscapedPathKey;
        }

        @NotNull
        public String getIsDirKey() {
            return this.myIsDirKey;
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private ChangeComparator() {
        }

        @Override
        public int compare(Change o1, Change o2) {
            ContentRevision bRev2;
            ContentRevision bRev1 = o1.getBeforeRevision();
            int delta = ChangeComparator.compareRevisions(bRev1, bRev2 = o2.getBeforeRevision());
            if (delta != 0) {
                return delta;
            }
            ContentRevision aRev1 = o1.getAfterRevision();
            ContentRevision aRev2 = o2.getAfterRevision();
            return ChangeComparator.compareRevisions(aRev1, aRev2);
        }

        private static int compareRevisions(@Nullable ContentRevision bRev1, @Nullable ContentRevision bRev2) {
            if (bRev1 == null && bRev2 == null) {
                return 0;
            }
            if (bRev1 == null) {
                return -1;
            }
            if (bRev2 == null) {
                return 1;
            }
            String path1 = bRev1.getFile().getPath();
            String path2 = bRev2.getFile().getPath();
            return path1.compareTo(path2);
        }
    }
}

