/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.VcsPreviewPanel;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsColorsPageFactory
implements ColorAndFontPanelFactory,
ColorAndFontDescriptorsProvider,
DisplayPrioritySortable {
    @NotNull
    public NewColorAndFontPanel createPanel(final @NotNull ColorAndFontOptions options) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        final OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, VcsColorsPageFactory.getVcsGroup());
        final VcsPreviewPanel previewPanel = new VcsPreviewPanel();
        schemesPanel.addListener((ColorAndFontSettingsListener)new ColorAndFontSettingsListener.Abstract(){

            public void schemeChanged(@NotNull Object source) {
                previewPanel.setColorScheme(options.getSelectedScheme());
                optionsPanel.updateOptionsList();
            }
        });
        return new NewColorAndFontPanel(schemesPanel, (OptionsPanel)optionsPanel, (PreviewPanel)previewPanel, VcsColorsPageFactory.getVcsGroup(), null, null);
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        return new AttributesDescriptor[0];
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        ArrayList<ColorDescriptor> descriptors = new ArrayList<ColorDescriptor>();
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.added.lines", (Object[])new Object[0]), EditorColors.ADDED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.modified.lines", (Object[])new Object[0]), EditorColors.MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.deleted.lines", (Object[])new Object[0]), EditorColors.DELETED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.whitespaces.modified.lines", (Object[])new Object[0]), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.border.lines", (Object[])new Object[0]), EditorColors.BORDER_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.ignored.added.lines", (Object[])new Object[0]), EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.ignored.modified.lines", (Object[])new Object[0]), EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.ignored.deleted.lines", (Object[])new Object[0]), EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations", (Object[])new Object[0]), EditorColors.ANNOTATIONS_COLOR, ColorDescriptor.Kind.FOREGROUND));
        List<ColorKey> colorKeys = AnnotationsSettings.ANCHOR_COLOR_KEYS;
        for (int i = 0; i < colorKeys.size(); ++i) {
            descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations.color.n", (Object[])new Object[]{i + 1}), colorKeys.get(i), ColorDescriptor.Kind.BACKGROUND));
        }
        return descriptors.toArray(ColorDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public String getPanelDisplayName() {
        return VcsColorsPageFactory.getVcsGroup();
    }

    @NotNull
    public String getDisplayName() {
        return VcsColorsPageFactory.getVcsGroup();
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }

    public static String getVcsGroup() {
        return ApplicationBundle.message((String)"title.vcs", (Object[])new Object[0]);
    }
}

