/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowAnnotateOperationsPopup
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        List<AnAction> actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
        e.getPresentation().setEnabled(actions != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<AnAction> actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
        if (actions == null) {
            return;
        }
        String title2 = this.getTemplatePresentation().getText();
        DefaultActionGroup group = new DefaultActionGroup(actions);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(title2, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        popup.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    private static List<AnAction> getActions(@NotNull DataContext context) {
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        TextAnnotationPresentation presentation = AnnotateToggleAction.getAnnotationPresentation(editor);
        if (presentation == null) {
            return null;
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        List actions = presentation.getActions(line);
        FileAnnotation fileAnnotation = AnnotateToggleAction.getFileAnnotation(editor);
        if (fileAnnotation != null) {
            int annotationLine = presentation.getAnnotationLine(line);
            actions = ContainerUtil.prepend(actions, (Object[])new AnAction[]{new ShowAffectedFilesAction(fileAnnotation, annotationLine)});
        }
        return (List)ContainerUtil.nullize(actions);
    }

    private static class ShowAffectedFilesAction
    extends DumbAwareAction {
        private final FileAnnotation myFileAnnotation;
        private final int myLine;
        private final FileAnnotation.RevisionChangesProvider myChangesProvider;
        private final VcsRevisionNumber myRevisionNumber;
        private final VirtualFile myFile;

        private ShowAffectedFilesAction(@NotNull FileAnnotation fileAnnotation, int line) {
            super(VcsBundle.messagePointer((String)"action.ShowAffectedFilesAction.show.affected.files.text", (Object[])new Object[0]), AllIcons.Actions.ListChanges);
            this.myFileAnnotation = fileAnnotation;
            this.myLine = line;
            this.myChangesProvider = fileAnnotation.getRevisionsChangesProvider();
            this.myRevisionNumber = fileAnnotation.getLineRevisionNumber(this.myLine);
            this.myFile = fileAnnotation.getFile();
        }

        public void update(@NotNull AnActionEvent e) {
            boolean visible = this.myChangesProvider != null && this.myFile != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && this.myRevisionNumber != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
            AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(this.myFileAnnotation.getProject(), this.myRevisionNumber, filePath, () -> this.myChangesProvider.getChangesIn(this.myLine));
        }
    }

    public static class Group
    extends ActionGroup
    implements DumbAware {
        public boolean hideIfNoVisibleChildren() {
            return true;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                return AnAction.EMPTY_ARRAY;
            }
            List actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
            return actions != null ? actions.toArray(AnAction.EMPTY_ARRAY) : AnAction.EMPTY_ARRAY;
        }
    }
}

