/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffActionExecutor {
    protected final DiffProvider myDiffProvider;
    protected final VirtualFile mySelectedFile;
    protected final Project myProject;
    private final Integer mySelectedLine;

    protected DiffActionExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
        this.myDiffProvider = diffProvider;
        this.mySelectedFile = selectedFile;
        this.myProject = project;
        this.mySelectedLine = DiffActionExecutor.getSelectedLine(project, this.mySelectedFile, editor);
    }

    @Nullable
    private static Integer getSelectedLine(@NotNull Project project, @NotNull VirtualFile file, @Nullable Editor contextEditor) {
        FileEditor fileEditor;
        VirtualFile contextFile;
        Editor editor = null;
        if (contextEditor != null && Comparing.equal((Object)(contextFile = FileDocumentManager.getInstance().getFile(contextEditor.getDocument())), (Object)file)) {
            editor = contextEditor;
        }
        if (editor == null && (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file)) instanceof TextEditor) {
            editor = ((TextEditor)fileEditor).getEditor();
        }
        if (editor == null) {
            return null;
        }
        return editor.getCaretModel().getLogicalPosition().line;
    }

    @NotNull
    protected DiffContent createRemote(@NotNull ContentRevision fileRevision) throws IOException, VcsException {
        DocumentContent diffContent;
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (fileRevision instanceof ByteBackedContentRevision) {
            byte[] content2 = ((ByteBackedContentRevision)fileRevision).getContentAsBytes();
            if (content2 == null) {
                throw new VcsException("Failed to load content");
            }
            diffContent = contentFactory.createFromBytes(this.myProject, content2, fileRevision.getFile());
        } else {
            String content3 = fileRevision.getContent();
            if (content3 == null) {
                throw new VcsException("Failed to load content");
            }
            diffContent = contentFactory.create(this.myProject, content3, fileRevision.getFile());
        }
        diffContent.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)Pair.create((Object)fileRevision.getFile(), (Object)fileRevision.getRevisionNumber()));
        return diffContent;
    }

    public void showDiff() {
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)new MyDiffProducer());
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    @Deprecated
    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
        DiffActionExecutor.showDiff(diffProvider, revisionNumber, selectedFile, project);
    }

    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project) {
        CompareToFixedExecutor executor = new CompareToFixedExecutor(diffProvider, selectedFile, project, null, revisionNumber);
        executor.showDiff();
    }

    @Nullable
    protected abstract ContentRevision getContentRevision();

    public static class DeletionAwareExecutor
    extends DiffActionExecutor {
        private boolean myFileStillExists;

        public DeletionAwareExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
            super(diffProvider, selectedFile, project, editor);
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            ItemLatestState itemState = this.myDiffProvider.getLastRevision(this.mySelectedFile);
            if (itemState == null) {
                return null;
            }
            this.myFileStillExists = itemState.isItemExists();
            return this.myDiffProvider.createFileContent(itemState.getNumber(), this.mySelectedFile);
        }

        @Override
        @NotNull
        protected DiffContent createRemote(@NotNull ContentRevision fileRevision) throws IOException, VcsException {
            if (this.myFileStillExists) {
                return super.createRemote(fileRevision);
            }
            return DiffContentFactory.getInstance().createEmpty();
        }
    }

    public static class CompareToCurrentExecutor
    extends DiffActionExecutor {
        public CompareToCurrentExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
            super(diffProvider, selectedFile, project, editor);
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            return this.myDiffProvider.createCurrentFileContent(this.mySelectedFile);
        }
    }

    public static class CompareToFixedExecutor
    extends DiffActionExecutor {
        private final VcsRevisionNumber myNumber;

        public CompareToFixedExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor, @NotNull VcsRevisionNumber number) {
            super(diffProvider, selectedFile, project, editor);
            this.myNumber = number;
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            return this.myDiffProvider.createFileContent(this.myNumber, this.mySelectedFile);
        }
    }

    private class MyDiffProducer
    implements DiffRequestProducer {
        private final FilePath myFilePath;

        private MyDiffProducer() {
            this.myFilePath = VcsUtil.getFilePath((VirtualFile)DiffActionExecutor.this.mySelectedFile);
        }

        @NotNull
        public String getName() {
            return this.myFilePath.getPresentableUrl();
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            ContentRevision contentRevision = DiffActionExecutor.this.getContentRevision();
            if (contentRevision == null) {
                throw new DiffRequestProducerException("Can't get revision content");
            }
            try {
                String title2;
                String title1;
                VcsRevisionNumber currentRevision;
                DiffContent content1 = DiffActionExecutor.this.createRemote(contentRevision);
                DiffContent content2 = DiffContentFactory.getInstance().create(DiffActionExecutor.this.myProject, DiffActionExecutor.this.mySelectedFile);
                String title3 = DiffRequestFactory.getInstance().getTitle(DiffActionExecutor.this.mySelectedFile);
                VcsRevisionNumber revisionNumber = contentRevision.getRevisionNumber();
                boolean inverted = false;
                FileStatus status = ChangeListManager.getInstance((Project)DiffActionExecutor.this.myProject).getStatus(DiffActionExecutor.this.mySelectedFile);
                boolean noLocalChanges = FileStatus.NOT_CHANGED.equals(status) || FileStatus.UNKNOWN.equals(status) || FileStatus.IGNORED.equals(status);
                VcsRevisionNumber vcsRevisionNumber = currentRevision = noLocalChanges ? DiffActionExecutor.this.myDiffProvider.getCurrentRevision(DiffActionExecutor.this.mySelectedFile) : null;
                if (currentRevision != null) {
                    inverted = revisionNumber.compareTo((Object)currentRevision) > 0;
                    title1 = revisionNumber.asString();
                    title2 = VcsBundle.message((String)"diff.title.local.with.number", (Object[])new Object[]{currentRevision.asString()});
                } else {
                    title1 = revisionNumber.asString();
                    title2 = VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
                }
                if (inverted) {
                    SimpleDiffRequest request = new SimpleDiffRequest(title3, content2, content1, title2, title1);
                    if (DiffActionExecutor.this.mySelectedLine != null) {
                        request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)DiffActionExecutor.this.mySelectedLine));
                    }
                    request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
                    return request;
                }
                SimpleDiffRequest request = new SimpleDiffRequest(title3, content1, content2, title1, title2);
                if (DiffActionExecutor.this.mySelectedLine != null) {
                    request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)DiffActionExecutor.this.mySelectedLine));
                }
                request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
                return request;
            }
            catch (VcsException | IOException e) {
                throw new DiffRequestProducerException(e);
            }
        }
    }
}

