/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Consumer;
import com.intellij.util.TreeItem;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithSelectedRevisionAction
extends AbstractVcsAction {
    @Override
    public void update(@NotNull VcsContext e, @NotNull Presentation presentation) {
        FilePath filePath = e.getSelectedFilePath();
        if (filePath != null && filePath.isDirectory()) {
            presentation.setVisible(CompareWithSelectedRevisionAction.isVisibleForDirectory(e));
            presentation.setEnabled(CompareWithSelectedRevisionAction.isEnabledForDirectory(e, filePath));
        } else {
            AbstractShowDiffAction.updateDiffAction(presentation, e);
        }
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        VirtualFile file = vcsContext.getSelectedFiles()[0];
        Project project = vcsContext.getProject();
        AbstractVcs vcs = Objects.requireNonNull(ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file));
        VcsCachingHistory.collectInBackground(vcs, VcsUtil.getFilePath((VirtualFile)file), VcsBackgroundableActions.COMPARE_WITH, (Consumer<? super VcsHistorySession>)((Consumer)session -> {
            if (session == null) {
                return;
            }
            List revisions = session.getRevisionList();
            HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
            if (treeHistoryProvider != null) {
                CompareWithSelectedRevisionAction.showTreePopup(treeHistoryProvider.createTreeOn(revisions), project, (Consumer<? super VcsFileRevision>)((Consumer)selected -> this.showSelectedRevision(selected.getRevisionNumber(), vcs, file, project)));
            } else {
                CompareWithSelectedRevisionAction.showListPopup(revisions, project, (Consumer<? super VcsFileRevision>)((Consumer)selected -> this.showSelectedRevision(selected.getRevisionNumber(), vcs, file, project)), true);
            }
        }));
    }

    protected void showSelectedRevision(@NotNull VcsRevisionNumber selected, @NotNull AbstractVcs vcs, @NotNull VirtualFile file, @NotNull Project project) {
        if (file.isDirectory()) {
            DiffProvider diffProvider = Objects.requireNonNull(vcs.getDiffProvider());
            VcsDiffUtil.showChangesWithWorkingDirLater(project, file, selected, diffProvider);
        } else {
            DiffActionExecutor.showDiff(vcs.getDiffProvider(), selected, file, project);
        }
    }

    private static void showTreePopup(List<TreeItem<VcsFileRevision>> roots, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer) {
        TreeTableView treeTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)new TreeNodeAdapter(null, null, roots), new ColumnInfo[]{Holder.BRANCH_COLUMN, Holder.REVISION_COLUMN, Holder.DATE_COLUMN, Holder.AUTHOR_COLUMN}));
        Runnable runnable = () -> {
            int index = treeTable.getSelectionModel().getMinSelectionIndex();
            if (index == -1) {
                return;
            }
            VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        treeTable.setSelectionMode(0);
        new PopupChooserBuilder((JTable)treeTable).setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable).setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel(treeTable)).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").createPopup().showCenteredInCurrentWindow(project);
        int lastRow = treeTable.getRowCount() - 1;
        if (lastRow < 0) {
            return;
        }
        treeTable.getSelectionModel().addSelectionInterval(lastRow, lastRow);
        treeTable.scrollRectToVisible(treeTable.getCellRect(lastRow, 0, true));
    }

    @Nullable
    private static VcsFileRevision getRevisionAt(TreeTableView treeTable, int index) {
        List items = treeTable.getItems();
        if (items.size() <= index) {
            return null;
        }
        return ((TreeNodeAdapter)items.get(index)).getRevision();
    }

    private static JPanel createCommentsPanel(final TreeTableView treeTable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                int index = treeTable.getSelectionModel().getMinSelectionIndex();
                if (index == -1) {
                    textArea.setText("");
                } else {
                    VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
                    if (revision != null) {
                        textArea.setText(revision.getCommitMessage());
                    } else {
                        textArea.setText("");
                    }
                }
            }
        });
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        panel2.add((Component)textScrollPane, "Center");
        textScrollPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]), (boolean)false));
        return panel2;
    }

    private static JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setRows(5);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        return textArea;
    }

    public static void showListPopup(final List<VcsFileRevision> revisions, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer, boolean showComments) {
        ColumnInfo[] columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
        for (VcsFileRevision revision : revisions) {
            if (revision.getBranchName() == null) continue;
            columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.BRANCH_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
            break;
        }
        final TableView table = new TableView(new ListTableModel(columns, revisions, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable = () -> {
            VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        new SpeedSearchBase<TableView>(table){

            protected int getSelectedIndex() {
                return table.getSelectedRow();
            }

            protected int convertIndexToModel(int viewIndex) {
                return table.convertRowIndexToModel(viewIndex);
            }

            protected Object @NotNull [] getAllElements() {
                return revisions.toArray();
            }

            protected String getElementText(Object element) {
                VcsFileRevision revision = (VcsFileRevision)element;
                return revision.getRevisionNumber().asString() + " " + revision.getBranchName() + " " + revision.getAuthor();
            }

            protected void selectElement(Object element, String selectedText) {
                VcsFileRevision revision = (VcsFileRevision)element;
                TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TableView)this.myComponent).convertRowIndexToView(revisions.indexOf(revision))});
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
            }
        };
        table.setMinimumSize((Dimension)new JBDimension(300, 50));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)table);
        if (showComments) {
            builder.setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel((TableView<VcsFileRevision>)table));
        }
        builder.setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").setMinSize((Dimension)new JBDimension(300, 300));
        JBPopup popup = builder.createPopup();
        popup.showCenteredInCurrentWindow(project);
    }

    private static JPanel createCommentsPanel(final TableView<VcsFileRevision> table) {
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
                if (revision == null) {
                    textArea.setText("");
                } else {
                    textArea.setText(revision.getCommitMessage());
                    textArea.select(0, 0);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]));
        jPanel.add((Component)commentLabel, "North");
        commentLabel.setBorder(IdeBorderFactory.createBorder((int)11));
        textScrollPane.setBorder(null);
        jPanel.add((Component)textScrollPane, "Center");
        jPanel.setPreferredSize((Dimension)new JBDimension(300, 100));
        return jPanel;
    }

    private static boolean isVisibleForDirectory(@NotNull VcsContext vcsContext) {
        return vcsContext.getProject() != null;
    }

    private static boolean isEnabledForDirectory(@NotNull VcsContext vcsContext, @NotNull FilePath filePath) {
        assert (filePath.isDirectory()) : "Implementation only for directories!";
        Project project = vcsContext.getProject();
        if (project == null) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(filePath);
        DiffProvider diffProvider = vcs != null ? vcs.getDiffProvider() : null;
        return diffProvider != null && diffProvider.canCompareWithWorkingDir();
    }

    private static class TreeNodeAdapter
    extends DefaultMutableTreeNode {
        private final TreeItem<VcsFileRevision> myRevision;

        TreeNodeAdapter(TreeNodeAdapter parent, TreeItem<VcsFileRevision> revision, List<TreeItem<VcsFileRevision>> children) {
            if (parent != null) {
                parent.add(this);
            }
            this.myRevision = revision;
            for (TreeItem<VcsFileRevision> treeItem : children) {
                new TreeNodeAdapter(this, treeItem, treeItem.getChildren());
            }
        }

        public VcsFileRevision getRevision() {
            return (VcsFileRevision)this.myRevision.getData();
        }
    }

    private static class Holder {
        private static final ColumnInfo<TreeNodeAdapter, String> BRANCH_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getBranchName();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> REVISION_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> DATE_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.filter", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return DateFormatUtil.formatPrettyDateTime((Date)object.getRevision().getRevisionDate());
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> AUTHOR_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> REVISION_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> DATE_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                Date date = vcsFileRevision.getRevisionDate();
                return date == null ? "" : DateFormatUtil.formatPrettyDateTime((Date)date);
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> AUTHOR_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> BRANCH_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getBranchName();
            }
        };

        private Holder() {
        }
    }
}

