/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesActionKt;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0015J\b\u0010\u001a\u001a\u00020\tH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/actions/CommonCheckinFilesAction;", "Lcom/intellij/openapi/vcs/actions/AbstractCommonCheckinAction;", "()V", "appendSubject", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "checkinActionName", "approximatelyHasRoots", "", "getActionName", "getInitiallySelectedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "context", "project", "Lcom/intellij/openapi/project/Project;", "getRoots", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;)[Lcom/intellij/openapi/vcs/FilePath;", "isApplicableRoot", "path", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "isForceUpdateCommitStateFromContext", "intellij.platform.vcs.impl"})
public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected String getActionName(@NotNull VcsContext dataContext) {
        AbstractVcs abstractVcs = CommonCheckinFilesActionKt.access$getCommonVcs(dataContext);
        String actionName = abstractVcs != null && (abstractVcs = abstractVcs.getCheckinEnvironment()) != null ? abstractVcs.getCheckinOperationName() : null;
        String string = actionName;
        if (string == null) {
            string = VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        return this.appendSubject(dataContext, string);
    }

    private final String appendSubject(VcsContext dataContext, String checkinActionName) {
        List roots = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)CommonCheckinFilesActionKt.access$getRoots(dataContext), (int)2));
        if (roots.isEmpty()) {
            return checkinActionName;
        }
        String messageKey = ((FilePath)roots.get(0)).isDirectory() ? "action.name.checkin.directory" : "action.name.checkin.file";
        return VcsBundle.message((String)StringUtil.pluralize((String)messageKey, (int)roots.size()), (Object[])new Object[]{checkinActionName});
    }

    @Override
    @NotNull
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultChangeList = manager.getDefaultChangeList();
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context)) {
            LocalChangeList localChangeList;
            if (root.getVirtualFile() == null) continue;
            Collection changes = manager.getChangesIn(root);
            if (ContainerUtil.intersects((Collection)changes, (Collection)defaultChangeList.getChanges())) {
                return defaultChangeList;
            }
            if ((Change)CollectionsKt.firstOrNull((Iterable)changes) != null) {
                Change change;
                boolean bl = false;
                boolean bl2 = false;
                Change it = change;
                boolean bl3 = false;
                localChangeList = manager.getChangeList(it);
            } else {
                localChangeList = null;
            }
            result2 = localChangeList;
        }
        LocalChangeList localChangeList = result2;
        if (localChangeList == null) {
            localChangeList = defaultChangeList;
        }
        return localChangeList;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = CommonCheckinFilesActionKt.access$getRoots(dataContext);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FilePath it = (FilePath)element$iv;
                boolean bl2 = false;
                if (!this.isApplicableRoot(it, dataContext)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicableRoot(@NotNull FilePath path2, @NotNull VcsContext dataContext) {
        Project project = dataContext.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project);
        FileStatus status = manager.getStatus(path2);
        if (!path2.isDirectory()) {
            if (!(Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true)) return false;
        }
        if (!(Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED) ^ true)) return false;
        VirtualFile virtualFile = path2.getVirtualFile();
        if (virtualFile == null) return true;
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile it = virtualFile2;
        boolean bl3 = false;
        if (!this.isApplicableRoot(it, status, dataContext)) return false;
        return true;
    }

    @Deprecated(message="Use `isApplicableRoot(FilePath, VcsContext)` instead", replaceWith=@ReplaceWith(imports={}, expression="isApplicableRoot()"))
    protected boolean isApplicableRoot(@NotNull VirtualFile file, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        return true;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext dataContext) {
        return dataContext.getSelectedFilePaths();
    }

    @Override
    protected boolean isForceUpdateCommitStateFromContext() {
        return true;
    }
}

