/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
UpToDateLineNumberListener {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    AnnotateRevisionAction(@Nullable String text2, @Nullable String description, @Nullable Icon icon2, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        super(text2, description, icon2);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.myAnnotation.getFile() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Nullable
    protected abstract VcsFileRevision getRevision(int var1);

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        VcsFileRevision revision = this.getFileRevision(e);
        if (revision == null) {
            return null;
        }
        FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new MyVcsVirtualFile(filePath, revision, currentFileType);
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        return this.getRevision(this.currentLine);
    }

    @Override
    protected int getAnnotatedLine(@NotNull AnActionEvent e) {
        if (this.currentLine < 0) {
            return super.getAnnotatedLine(e);
        }
        return this.currentLine;
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    private static class MyVcsVirtualFile
    extends VcsVirtualFile {
        @NotNull
        private final FileType myCurrentFileType;

        MyVcsVirtualFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull FileType currentFileType) {
            super(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
            this.myCurrentFileType = currentFileType;
        }

        @NotNull
        public FileType getFileType() {
            FileType type = super.getFileType();
            if (!type.isBinary()) {
                return type;
            }
            if (!this.myCurrentFileType.isBinary()) {
                return this.myCurrentFileType;
            }
            return PlainTextFileType.INSTANCE;
        }
    }
}

