/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AnnotateLocalFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateLocalFileAction.class);

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null || file.isDirectory() || file.getFileType().isBinary()) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(file);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        VirtualFile file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file).isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
        return ContainerUtil.exists(editors, editor -> AnnotateToggleAction.hasVcsAnnotations(editor));
    }

    private static void perform(AnActionEvent e, boolean selected) {
        if (!selected) {
            List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
            for (Editor editor : editors) {
                AnnotateToggleAction.closeVcsAnnotations(editor);
            }
        } else {
            Project project = Objects.requireNonNull(e.getProject());
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                Object[] fileEditors;
                VirtualFile selectedFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
                if (editor == null) {
                    Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"dialog.message.can.t.create.text.editor.for", (Object[])new Object[]{selectedFile.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                    LOG.warn(String.format("Can't create text editor for file: valid - %s; file type - %s; editors - %s", selectedFile.isValid(), selectedFile.getFileType().getName(), Arrays.toString(fileEditors)));
                    return;
                }
            }
            AnnotateLocalFileAction.doAnnotate(editor, project);
        }
    }

    private static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project) {
        final VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null) {
            return;
        }
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionLock actionLock = VcsAnnotateUtil.getBackgroundableLock(project, file);
        actionLock.lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, (FileAnnotation)fileAnnotationRef.get(), vcs);
                }
            }

            public void onFinished() {
                actionLock.unlock();
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull DataContext context) {
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return Collections.singletonList(editor);
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file == null) {
            return Collections.emptyList();
        }
        return VcsAnnotateUtil.getEditors(project, file);
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateLocalFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            return AnnotateLocalFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateLocalFileAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            AnnotateLocalFileAction.perform(e, selected);
        }
    }
}

