/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourPutBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey");
    public static final Key<Map<FilePath, ContentRevision>> ourBaseRevisions = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    public static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance(BaseRevisionTextPatchEP.class);
    private final String myBaseDir;

    public BaseRevisionTextPatchEP(Project project) {
        this.myBaseDir = project.getBasePath();
    }

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    public CharSequence provideContent(@NotNull String path2, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourPutBaseRevisionTextKey))) {
            File file = new File(this.myBaseDir, path2);
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
            Map baseRevisions = (Map)commitContext.getUserData(ourBaseRevisions);
            if (baseRevisions == null) {
                return null;
            }
            ContentRevision baseRevision = (ContentRevision)baseRevisions.get(filePath);
            if (baseRevision == null) {
                return null;
            }
            try {
                return baseRevision.getContent();
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            Map map2 = (Map)commitContext.getUserData(ourStoredTexts);
            if (map2 != null) {
                File file = new File(this.myBaseDir, path2);
                return (CharSequence)map2.get(file.getPath());
            }
        }
        return null;
    }

    public void consumeContent(@NotNull String path2, @NotNull CharSequence content2, CommitContext commitContext) {
    }

    public void consumeContentBeforePatchApplied(@NotNull String path2, @NotNull CharSequence content2, CommitContext commitContext) {
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourStoredTexts);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map2);
        }
        File file = new File(this.myBaseDir, path2);
        map2.put(file.getPath(), content2.toString());
    }
}

