/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.conversion.impl.ui.ConvertProjectDialog;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.IdeBundle;
import com.intellij.impl.ConversionResultImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class ConversionServiceImpl
extends ConversionService {
    private static final Logger LOG = Logger.getInstance(ConversionServiceImpl.class);

    @NotNull
    public ConversionResult convertSilently(@NotNull Path projectPath, @NotNull ConversionListener listener2) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            if (!ConversionServiceImpl.isConversionNeeded(context)) {
                return ConversionResultImpl.CONVERSION_NOT_NEEDED;
            }
            listener2.conversionNeeded();
            List<ConversionRunner> runners = ConversionServiceImpl.getConversionRunners(context);
            HashSet affectedFiles = new HashSet();
            for (ConversionRunner runner : runners) {
                affectedFiles.addAll(runner.getAffectedFiles());
            }
            List readOnlyFiles = ConversionRunner.getReadOnlyFiles(affectedFiles);
            if (!readOnlyFiles.isEmpty()) {
                listener2.cannotWriteToFiles(ContainerUtil.map((Collection)readOnlyFiles, path2 -> path2.toFile()));
                return ConversionResultImpl.ERROR_OCCURRED;
            }
            File backupDir = ProjectConversionUtil.backupFiles(affectedFiles, (File)context.getProjectBaseDir());
            ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                runner.preProcess();
                runner.process();
                runner.postProcess();
                usedRunners.add(runner);
            }
            context.saveFiles(affectedFiles, usedRunners);
            listener2.successfullyConverted(backupDir);
            ConversionServiceImpl.saveConversionResult(context);
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException | IOException e) {
            listener2.error(e.getMessage());
            return ConversionResultImpl.ERROR_OCCURRED;
        }
    }

    @NotNull
    public ConversionResult convert(@NotNull Path projectPath) throws CannotConvertException {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !ConverterProvider.EP_NAME.hasAnyExtensions() || !Files.exists(projectPath, new LinkOption[0])) {
            return ConversionResultImpl.CONVERSION_NOT_NEEDED;
        }
        ConversionContextImpl context = new ConversionContextImpl(projectPath);
        if (!ConversionServiceImpl.isConversionNeeded(context)) {
            return ConversionResultImpl.CONVERSION_NOT_NEEDED;
        }
        List<ConversionRunner> converters = ConversionServiceImpl.getConversionRunners(context);
        Ref ref = new Ref((Object)ConversionResultImpl.CONVERSION_CANCELED);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ConvertProjectDialog dialog = new ConvertProjectDialog(context, converters);
            dialog.show();
            if (dialog.isConverted()) {
                ref.set((Object)new ConversionResultImpl(converters));
            }
        });
        if (!ref.isNull()) {
            ConversionServiceImpl.saveConversionResult(context);
        }
        return (ConversionResult)ref.get();
    }

    @NotNull
    private static List<ConversionRunner> getConversionRunners(ConversionContextImpl context) throws CannotConvertException {
        List<ConversionRunner> converters = ConversionServiceImpl.getSortedConverters(context);
        Iterator<ConversionRunner> iterator = converters.iterator();
        HashSet<String> convertersToRunIds = new HashSet<String>();
        while (iterator.hasNext()) {
            ConversionRunner runner = iterator.next();
            boolean conversionNeeded = runner.isConversionNeeded();
            if (!conversionNeeded) {
                for (String id : runner.getProvider().getPrecedingConverterIds()) {
                    if (!convertersToRunIds.contains(id)) continue;
                    conversionNeeded = true;
                    break;
                }
            }
            if (conversionNeeded) {
                convertersToRunIds.add(runner.getProvider().getId());
                continue;
            }
            iterator.remove();
        }
        return converters;
    }

    private static boolean isConversionNeeded(@NotNull ConversionContextImpl context) {
        try {
            List<ConversionRunner> runners = ConversionServiceImpl.getSortedConverters(context);
            if (runners.isEmpty()) {
                return false;
            }
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                return true;
            }
            ConversionServiceImpl.saveConversionResult(context);
        }
        catch (CannotConvertException e) {
            LOG.info("Cannot check whether conversion of project files is needed or not, conversion won't be performed", (Throwable)e);
        }
        return false;
    }

    private static List<ConversionRunner> getSortedConverters(@NotNull ConversionContextImpl context) throws CannotConvertException {
        Set<String> performedConversionIds;
        boolean changed;
        CachedConversionResult conversionResult = ConversionServiceImpl.loadCachedConversionResult(context.getProjectFile());
        ObjectLongHashMap<String> oldMap = conversionResult.myProjectFilesTimestamps;
        ObjectLongHashMap<String> newMap = ConversionServiceImpl.getProjectFilesMap(context);
        LOG.debug("Checking project files");
        if (LOG.isDebugEnabled()) {
            Ref changedRef = new Ref((Object)false);
            newMap.forEachEntry((path2, newValue) -> {
                long oldValue = oldMap.get(path2);
                if (oldValue == -1L) {
                    LOG.debug(" new file: " + path2);
                    changedRef.set((Object)true);
                } else if (newValue != oldValue) {
                    LOG.debug(" changed file: " + path2);
                    changedRef.set((Object)true);
                }
                return true;
            });
            changed = (Boolean)changedRef.get();
        } else {
            boolean bl = changed = !newMap.forEachEntry((path2, newValue) -> {
                boolean isFileChangedOrNew;
                long oldValue = oldMap.get(path2);
                boolean bl = isFileChangedOrNew = newValue != oldValue;
                if (isFileChangedOrNew) {
                    LOG.info("conversion will be performed because at least " + path2 + " is changed (oldLastModified=" + oldValue + ", newLastModified=" + newValue);
                }
                return !isFileChangedOrNew;
            });
        }
        if (changed) {
            performedConversionIds = Collections.emptySet();
            LOG.debug("Project files were modified.");
        } else {
            performedConversionIds = conversionResult.myAppliedConverters;
            LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
        }
        return ConversionServiceImpl.createConversionRunners(context, performedConversionIds);
    }

    @NotNull
    private static ObjectLongHashMap<String> getProjectFilesMap(@NotNull ConversionContextImpl context) throws CannotConvertException {
        Activity activity = StartUpMeasurer.startActivity((String)"conversion: project files collecting");
        ObjectLongHashMap result2 = context.getAllProjectFiles();
        activity.end();
        return result2;
    }

    @NotNull
    private static List<ConversionRunner> createConversionRunners(@NotNull ConversionContextImpl context, @NotNull Set<String> performedConversionIds) {
        ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
        List providers = ConverterProvider.EP_NAME.getExtensionList();
        for (ConverterProvider provider : providers) {
            if (performedConversionIds.contains(provider.getId())) continue;
            runners.add(new ConversionRunner(provider, context));
        }
        if (runners.isEmpty()) {
            return runners;
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ConverterProvidersGraph(providers)));
        DFSTBuilder builder = new DFSTBuilder(graph);
        if (!builder.isAcyclic()) {
            Couple pair = builder.getCircularDependency();
            LOG.error("cyclic dependencies between converters: " + ((ConverterProvider)pair.getFirst()).getId() + " and " + ((ConverterProvider)pair.getSecond()).getId());
        }
        Comparator comparator = builder.comparator();
        runners.sort((o1, o2) -> comparator.compare(o1.getProvider(), o2.getProvider()));
        return runners;
    }

    public void saveConversionResult(@NotNull Path projectPath) {
        try {
            ConversionServiceImpl.saveConversionResult(new ConversionContextImpl(projectPath));
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void saveConversionResult(@NotNull ConversionContextImpl context) throws CannotConvertException {
        Element root = new Element("conversion");
        Element appliedConverters = new Element("applied-converters");
        root.addContent(appliedConverters);
        for (ConverterProvider provider : ConverterProvider.EP_NAME.getExtensionList()) {
            appliedConverters.addContent(new Element("converter").setAttribute("id", provider.getId()));
        }
        Element projectFiles = new Element("project-files");
        root.addContent(projectFiles);
        ObjectLongHashMap<String> projectFilesMap = ConversionServiceImpl.getProjectFilesMap(context);
        projectFilesMap.forEachEntry((key, value) -> {
            projectFiles.addContent(new Element("file").setAttribute("path", key).setAttribute("timestamp", String.valueOf(value)));
            return true;
        });
        Path infoFile = ConversionServiceImpl.getConversionInfoFile(context.getProjectFile());
        try {
            JDOMUtil.write((Element)root, (Path)infoFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static CachedConversionResult loadCachedConversionResult(@NotNull File projectFile) {
        CachedConversionResult result2 = new CachedConversionResult();
        try {
            Path infoFile = ConversionServiceImpl.getConversionInfoFile(projectFile);
            if (!Files.exists(infoFile, new LinkOption[0])) {
                return result2;
            }
            Element root = JDOMUtil.load((Path)infoFile);
            for (Element child : root.getChildren()) {
                if (child.getName().equals("applied-converters")) {
                    for (Element element : child.getChildren()) {
                        String id = element.getAttributeValue("id");
                        if (id == null) continue;
                        result2.myAppliedConverters.add(id);
                    }
                    continue;
                }
                if (!child.getName().equals("project-files")) continue;
                List projectFiles = child.getChildren();
                result2.myProjectFilesTimestamps.ensureCapacity(projectFiles.size());
                for (Element element : projectFiles) {
                    String path2 = element.getAttributeValue("path");
                    String timestamp = element.getAttributeValue("timestamp");
                    if (path2 == null || timestamp == null) continue;
                    try {
                        result2.myProjectFilesTimestamps.put((Object)path2, Long.parseLong(timestamp));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            return result2;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return result2;
        }
    }

    @NotNull
    private static Path getConversionInfoFile(@NotNull File projectFile) {
        String dirName = PathUtil.suggestFileName((String)(projectFile.getName() + Integer.toHexString(projectFile.getAbsolutePath().hashCode())));
        return Paths.get(PathManager.getSystemPath(), "conversion", dirName + ".xml");
    }

    @NotNull
    public ConversionResult convertModule(@NotNull Project project, @NotNull Path moduleFile) {
        String url = project.getPresentableUrl();
        assert (url != null) : project;
        Path projectPath = Paths.get(url, new String[0]);
        if (!ConversionServiceImpl.isConversionNeeded(projectPath, moduleFile)) {
            return ConversionResultImpl.CONVERSION_NOT_NEEDED;
        }
        int res = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.module.file.has.an.older.format.do.you.want.to.convert.it", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (res != 0) {
            return ConversionResultImpl.CONVERSION_CANCELED;
        }
        if (!Files.isWritable(moduleFile)) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{moduleFile.toAbsolutePath().toString()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            return ConversionResultImpl.ERROR_OCCURRED;
        }
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
            File backupFile = ProjectConversionUtil.backupFile((Path)moduleFile);
            ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                runner.convertModule(moduleFile);
                usedRunners.add(runner);
            }
            context.saveFiles(Collections.singletonList(moduleFile), usedRunners);
            Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"message.your.module.was.successfully.converted.br.old.version.was.saved.to.0", (Object[])new Object[]{backupFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)VcsBundle.message((String)"dialog.title.cannot.convert.module", (Object[])new Object[0]));
            return ConversionResultImpl.ERROR_OCCURRED;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return ConversionResultImpl.ERROR_OCCURRED;
        }
    }

    private static boolean isConversionNeeded(Path projectPath, Path moduleFile) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                return true;
            }
            return false;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static class ConverterProvidersGraph
    implements InboundSemiGraph<ConverterProvider> {
        private final List<ConverterProvider> myProviders;

        ConverterProvidersGraph(@NotNull List<ConverterProvider> providers) {
            this.myProviders = providers;
        }

        @NotNull
        public Collection<ConverterProvider> getNodes() {
            return this.myProviders;
        }

        @NotNull
        public Iterator<ConverterProvider> getIn(ConverterProvider n) {
            ArrayList<ConverterProvider> preceding = new ArrayList<ConverterProvider>();
            for (String id : n.getPrecedingConverterIds()) {
                for (ConverterProvider provider : this.myProviders) {
                    if (!provider.getId().equals(id)) continue;
                    preceding.add(provider);
                }
            }
            return preceding.iterator();
        }
    }

    private static final class CachedConversionResult {
        public final Set<String> myAppliedConverters = new THashSet();
        public final ObjectLongHashMap<String> myProjectFilesTimestamps = new ObjectLongHashMap();

        private CachedConversionResult() {
        }
    }
}

