/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class NewBranchAction<T extends Repository>
extends DumbAwareAction {
    public static final Icon icon = AllIcons.General.Add;
    protected final List<T> myRepositories;
    protected final Project myProject;

    public NewBranchAction(@NotNull Project project, @NotNull List<T> repositories) {
        super(DvcsBundle.messagePointer("new.branch.action.text", new Object[0]), DvcsBundle.messagePointer("new.branch.action.description", new Object[0]), icon);
        this.myRepositories = repositories;
        this.myProject = project;
    }

    public void update(@NotNull AnActionEvent e) {
        NewBranchAction.checkIfAnyRepositoryIsFresh(e, this.myRepositories);
    }

    public static <T extends Repository> void checkIfAnyRepositoryIsFresh(@NotNull AnActionEvent e, @NotNull List<T> repositories) {
        if (DvcsUtil.anyRepositoryIsFresh(repositories)) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(DvcsBundle.messagePointer("action.presentation.NewBranchAction.description", new Object[0]));
        }
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1);
}

