/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareBranchesDiffPanel
extends JPanel {
    private final String myBranchName;
    private final Project myProject;
    private final String myCurrentBranchName;
    private final DvcsCompareSettings myVcsSettings;
    @Nullable
    private CommitCompareInfo myCompareInfo;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public CompareBranchesDiffPanel(@NotNull Project project, @NotNull DvcsCompareSettings settings, @NotNull String branchName, @NotNull String currentBranchName) {
        this.myProject = project;
        this.myCurrentBranchName = currentBranchName;
        this.myBranchName = branchName;
        this.myVcsSettings = settings;
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.setFocusable(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                CompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                CompareBranchesDiffPanel.this.refreshView();
            }
        });
        this.updateLabelText();
        this.myChangesBrowser = new MyChangesBrowser(project, Collections.emptyList());
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)this.myChangesBrowser, "Center");
    }

    public void setCompareInfo(@NotNull CommitCompareInfo compareInfo) {
        this.myCompareInfo = compareInfo;
        this.refreshView();
    }

    private void refreshView() {
        if (this.myCompareInfo != null) {
            boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
            this.updateLabelText();
            List<Change> diff = this.myCompareInfo.getTotalDiff();
            if (swapSides) {
                diff = DvcsBranchUtil.swapRevisions(diff);
            }
            this.myChangesBrowser.setChangesToDisplay(diff);
        }
    }

    private void updateLabelText() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        String branchNameText = XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.wrapInHtmlTag((String)this.myBranchName, (String)"code"), (String)"b");
        String currentBranchNameText = XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.wrapInHtmlTag((String)this.myCurrentBranchName, (String)"code"), (String)"b");
        String diffBetween = swapSides ? DvcsBundle.message("compare.branches.diff.panel.diff.between.files.in.branch.and.current.working.tree.on.branch", branchNameText, currentBranchNameText) : DvcsBundle.message("compare.branches.diff.panel.difference.between.current.working.tree.on.branch.and.files.in.branch", currentBranchNameText, branchNameText);
        String swapBranches = DvcsBundle.message("compare.branches.diff.panel.swap.branches", new Object[0]);
        this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)(diffBetween + "&emsp;<a href=\"\">" + swapBranches + "</a>")));
    }

    public void setEmptyText(@NotNull String text2) {
        this.myChangesBrowser.getViewer().setEmptyText(text2);
    }

    public void disableControls() {
        this.myLabel.setEnabled(false);
    }

    public void enableControls() {
        this.myLabel.setEnabled(true);
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        return this.myChangesBrowser.getPreferredFocusedComponent();
    }

    private class MyCopyChangesAction
    extends DumbAwareAction {
        MyCopyChangesAction() {
            super(DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action", new Object[0]), DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action.description", CompareBranchesDiffPanel.this.myBranchName), AllIcons.Actions.Download);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.GetVersion"));
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isEnabled = !CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible = CompareBranchesDiffPanel.this.myCompareInfo instanceof LocalCommitCompareInfo;
            e.getPresentation().setEnabled(isEnabled && isVisible);
            e.getPresentation().setVisible(isVisible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String title2 = DvcsBundle.message("compare.branches.diff.panel.get.from.branch.title", CompareBranchesDiffPanel.this.myBranchName);
            final List<Change> changes = CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(CompareBranchesDiffPanel.this.myProject, title2);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges(changes))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(title2);
            new Task.Modal(CompareBranchesDiffPanel.this.myProject, DvcsBundle.message("compare.branches.diff.panel.loading.content.from.branch.process", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        if (CompareBranchesDiffPanel.this.myCompareInfo != null) {
                            ((LocalCommitCompareInfo)CompareBranchesDiffPanel.this.myCompareInfo).copyChangesFromBranch(changes, swapSides);
                        }
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)DvcsBundle.message("compare.branches.diff.panel.can.not.copy.changes.error", new Object[0])));
                    }
                }

                public void onFinished() {
                    action.finish();
                    CompareBranchesDiffPanel.this.refreshView();
                }
            }.queue();
        }
    }

    private class MyChangesBrowser
    extends SimpleChangesBrowser {
        MyChangesBrowser(@NotNull Project project, List<? extends Change> changes) {
            super(project, false, true);
            this.setChangesToDisplay(changes);
        }

        @Override
        public void setChangesToDisplay(@NotNull Collection<? extends Change> changes) {
            List<Change> oldSelection = this.getSelectedChanges();
            super.setChangesToDisplay(changes);
            this.myViewer.setSelectedChanges(DvcsBranchUtil.swapRevisions(oldSelection));
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            return ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
        }
    }
}

