/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DvcsBranchUtil {
    @Nullable
    public static <T extends DvcsBranchInfo> T find(@Nullable Collection<T> branches, @Nullable Repository repository, @NotNull String sourceBranch) {
        if (branches == null) {
            return null;
        }
        return (T)((DvcsBranchInfo)ContainerUtil.find(branches, targetInfo -> DvcsBranchUtil.repoAndSourceAreEqual(repository, sourceBranch, targetInfo)));
    }

    private static boolean repoAndSourceAreEqual(@Nullable Repository repository, @NotNull String sourceBranch, @NotNull DvcsBranchInfo targetInfo) {
        return DvcsBranchUtil.getPathFor(repository).equals(targetInfo.repoPath) && StringUtil.equals((CharSequence)targetInfo.sourceName, (CharSequence)sourceBranch);
    }

    @NotNull
    public static String getPathFor(@Nullable Repository repository) {
        return repository == null ? "" : repository.getRoot().getPath();
    }

    @NotNull
    public static List<Change> swapRevisions(@NotNull List<? extends Change> changes) {
        return ContainerUtil.map(changes, change -> {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision == null || afterRevision == null) {
                return new Change(afterRevision, beforeRevision);
            }
            return new Change(afterRevision, beforeRevision, change.getFileStatus());
        });
    }
}

