/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.VcsScopeItem;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.scale.JBUIScale;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItemPresenter
implements ModelScopeItemPresenter {
    public int getScopeId() {
        return 10;
    }

    @NotNull
    public JRadioButton getButton(ModelScopeItem m) {
        JRadioButton button = new JRadioButton();
        button.setText(CodeInsightBundle.message((String)"scope.option.uncommitted.files", (Object[])new Object[0]));
        return button;
    }

    @NotNull
    public List<JComponent> getAdditionalComponents(JRadioButton button, ModelScopeItem m, Disposable dialogDisposable) {
        VcsScopeItem model = (VcsScopeItem)m;
        ComboBox myChangeLists = new ComboBox();
        myChangeLists.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            int availableWidth = myChangeLists.getWidth();
            if (availableWidth <= 0) {
                availableWidth = JBUIScale.scale((int)200);
            }
            if (label.getFontMetrics(label.getFont()).stringWidth((String)value) < availableWidth) {
                label.setText(value);
            } else {
                label.setText(StringUtil.trimLog((String)value, (int)50));
            }
        }));
        myChangeLists.setModel(model.getChangeListsModel());
        myChangeLists.setEnabled(button.isSelected());
        button.addItemListener(e -> myChangeLists.setEnabled(button.isSelected()));
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add((JComponent)myChangeLists);
        return components;
    }

    public boolean isApplicable(ModelScopeItem model) {
        return model instanceof VcsScopeItem;
    }

    @Nullable
    public ModelScopeItem tryCreate(@NotNull Project project, @NotNull AnalysisScope scope2, @Nullable Module module, @Nullable PsiElement context) {
        if (ChangeListManager.getInstance((Project)project).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project);
    }
}

