/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.impl.AbstractIsolatedMap;
import org.gradle.internal.snapshot.impl.AttributeDefinitionSnapshot;
import org.gradle.internal.snapshot.impl.BooleanValueSnapshot;
import org.gradle.internal.snapshot.impl.FileValueSnapshot;
import org.gradle.internal.snapshot.impl.IntegerValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedArray;
import org.gradle.internal.snapshot.impl.IsolatedEnumValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedImmutableManagedValue;
import org.gradle.internal.snapshot.impl.IsolatedList;
import org.gradle.internal.snapshot.impl.IsolatedManagedValue;
import org.gradle.internal.snapshot.impl.IsolatedMap;
import org.gradle.internal.snapshot.impl.IsolatedProperties;
import org.gradle.internal.snapshot.impl.IsolatedSerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedSet;
import org.gradle.internal.snapshot.impl.LongValueSnapshot;
import org.gradle.internal.snapshot.impl.MapEntrySnapshot;
import org.gradle.internal.snapshot.impl.NullValueSnapshot;
import org.gradle.internal.snapshot.impl.ShortValueSnapshot;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.internal.state.ManagedFactoryRegistry;

public class IsolatableSerializerRegistry
extends DefaultSerializerRegistry {
    private static final byte STRING_VALUE = 0;
    private static final byte BOOLEAN_VALUE = 1;
    private static final byte SHORT_VALUE = 2;
    private static final byte INTEGER_VALUE = 3;
    private static final byte LONG_VALUE = 4;
    private static final byte ATTRIBUTE_VALUE = 5;
    private static final byte MANAGED_VALUE = 6;
    private static final byte IMMUTABLE_MANAGED_VALUE = 7;
    private static final byte FILE_VALUE = 8;
    private static final byte NULL_VALUE = 9;
    private static final byte SERIALIZED_VALUE = 10;
    private static final byte ENUM_VALUE = 11;
    private static final byte ISOLATED_MAP = 12;
    private static final byte ISOLATED_ARRAY = 13;
    private static final byte ISOLATED_LIST = 14;
    private static final byte ISOLATED_SET = 15;
    private static final byte ISOLATED_PROPERTIES = 16;
    private static final byte ISOLATABLE_TYPE = 0;
    private static final byte ARRAY_TYPE = 1;
    private static final byte OTHER_TYPE = 2;
    private static final byte NULL_TYPE = 3;
    private final Map<Byte, IsolatableSerializer<?>> isolatableSerializers = Maps.newHashMap();
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ManagedFactoryRegistry managedFactoryRegistry;

    public IsolatableSerializerRegistry(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
        super(false);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.managedFactoryRegistry = managedFactoryRegistry;
        this.isolatableSerializers.put((byte)0, new StringValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)1, new BooleanValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)2, new ShortValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)3, new IntegerValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)4, new LongValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)5, new AttributeDefinitionSnapshotSerializer());
        this.isolatableSerializers.put((byte)6, new IsolatedManagedValueSerializer());
        this.isolatableSerializers.put((byte)7, new IsolatedImmutableManagedValueSerializer());
        this.isolatableSerializers.put((byte)8, new FileValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)10, new IsolatedSerializedValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)9, new NullValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)11, new IsolatedEnumValueSnapshotSerializer());
        this.isolatableSerializers.put((byte)12, new IsolatedMapSerializer());
        this.isolatableSerializers.put((byte)13, new IsolatedArraySerializer());
        this.isolatableSerializers.put((byte)14, new IsolatedListSerializer());
        this.isolatableSerializers.put((byte)15, new IsolatedSetSerializer());
        this.isolatableSerializers.put((byte)16, new IsolatedPropertiesSerializer());
        for (IsolatableSerializer<?> serializer : this.isolatableSerializers.values()) {
            this.register(serializer.getIsolatableClass(), (Serializer)Cast.uncheckedCast(serializer));
        }
    }

    public static IsolatableSerializerRegistry create(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
        return new IsolatableSerializerRegistry(classLoaderHierarchyHasher, managedFactoryRegistry);
    }

    public Isolatable<?> readIsolatable(Decoder decoder) throws Exception {
        byte type = decoder.readByte();
        Class<?> isolatableClass = this.isolatableSerializers.get(type).getIsolatableClass();
        return (Isolatable)this.build(isolatableClass).read(decoder);
    }

    public void writeIsolatable(Encoder encoder, Isolatable<?> isolatable) throws Exception {
        this.build(isolatable.getClass()).write(encoder, (Isolatable)Cast.uncheckedCast(isolatable));
    }

    private void readIsolatableSequence(Decoder decoder, ImmutableCollection.Builder<Isolatable<?>> builder) throws Exception {
        int size = decoder.readInt();
        for (int i = 0; i < size; ++i) {
            builder.add(this.readIsolatable(decoder));
        }
    }

    private void writeIsolatableSequence(Encoder encoder, Collection<Isolatable<?>> elements) throws Exception {
        encoder.writeInt(elements.size());
        for (Isolatable<?> isolatable : elements) {
            this.writeIsolatable(encoder, isolatable);
        }
    }

    private Object readState(Decoder decoder) throws Exception {
        byte stateType = decoder.readByte();
        if (stateType == 3) {
            return null;
        }
        if (stateType == 0) {
            return this.readIsolatable(decoder);
        }
        if (stateType == 1) {
            String stateClassName = decoder.readString();
            Class<?> stateClass = this.fromClassName(stateClassName);
            int size = decoder.readInt();
            Object state = Array.newInstance(stateClass, size);
            for (int i = 0; i < size; ++i) {
                Array.set(state, i, this.readState(decoder));
            }
            return state;
        }
        String stateClassName = decoder.readString();
        Class<?> stateClass = this.fromClassName(stateClassName);
        this.useJavaSerialization(stateClass);
        return this.build(stateClass).read(decoder);
    }

    private void writeState(Encoder encoder, Object state) throws Exception {
        if (state == null) {
            encoder.writeByte((byte)3);
        } else if (state instanceof Isolatable) {
            encoder.writeByte((byte)0);
            this.writeIsolatable(encoder, (Isolatable)state);
        } else if (state.getClass().isArray()) {
            encoder.writeByte((byte)1);
            encoder.writeString(state.getClass().getComponentType().getName());
            Object[] array = (Object[])state;
            int size = array.length;
            encoder.writeInt(size);
            for (int i = 0; i < size; ++i) {
                this.writeState(encoder, array[i]);
            }
        } else {
            encoder.writeByte((byte)2);
            encoder.writeString(state.getClass().getName());
            this.useJavaSerialization(state.getClass());
            this.build(state.getClass()).write(encoder, Cast.uncheckedCast(state));
        }
    }

    private Class<?> fromClassName(String className) throws Exception {
        return ClassLoaderUtils.classFromContextLoader(className);
    }

    private class IsolatedSetSerializer
    implements IsolatableSerializer<IsolatedSet> {
        private IsolatedSetSerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedSet value) throws Exception {
            encoder.writeByte((byte)15);
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, (Collection)value.getElements());
        }

        @Override
        public IsolatedSet read(Decoder decoder) throws Exception {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedSet((ImmutableSet<Isolatable<?>>)builder.build());
        }

        @Override
        public Class<IsolatedSet> getIsolatableClass() {
            return IsolatedSet.class;
        }
    }

    private class IsolatedListSerializer
    implements IsolatableSerializer<IsolatedList> {
        private IsolatedListSerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedList value) throws Exception {
            encoder.writeByte((byte)14);
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, value.getElements());
        }

        @Override
        public IsolatedList read(Decoder decoder) throws Exception {
            ImmutableList.Builder builder = ImmutableList.builder();
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedList((ImmutableList<Isolatable<?>>)builder.build());
        }

        @Override
        public Class<IsolatedList> getIsolatableClass() {
            return IsolatedList.class;
        }
    }

    private class IsolatedArraySerializer
    implements IsolatableSerializer<IsolatedArray> {
        private IsolatedArraySerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedArray value) throws Exception {
            encoder.writeByte((byte)13);
            encoder.writeString(value.getArrayType().getName());
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, value.getElements());
        }

        @Override
        public IsolatedArray read(Decoder decoder) throws Exception {
            ImmutableList.Builder builder = ImmutableList.builder();
            Class arrayType = IsolatableSerializerRegistry.this.fromClassName(decoder.readString());
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedArray(builder.build(), arrayType);
        }

        @Override
        public Class<IsolatedArray> getIsolatableClass() {
            return IsolatedArray.class;
        }
    }

    private class IsolatedPropertiesSerializer
    extends AbstractIsolatedMapSerializer<IsolatedProperties> {
        private IsolatedPropertiesSerializer() {
        }

        @Override
        protected IsolatedProperties getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> entries) {
            return new IsolatedProperties(entries);
        }

        @Override
        protected byte getTypeByte() {
            return 16;
        }

        @Override
        public Class<IsolatedProperties> getIsolatableClass() {
            return IsolatedProperties.class;
        }
    }

    private class IsolatedMapSerializer
    extends AbstractIsolatedMapSerializer<IsolatedMap> {
        private IsolatedMapSerializer() {
        }

        @Override
        public Class<IsolatedMap> getIsolatableClass() {
            return IsolatedMap.class;
        }

        @Override
        protected IsolatedMap getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> entries) {
            return new IsolatedMap(entries);
        }

        @Override
        protected byte getTypeByte() {
            return 12;
        }
    }

    private abstract class AbstractIsolatedMapSerializer<T extends AbstractIsolatedMap<?>>
    implements IsolatableSerializer<T> {
        private AbstractIsolatedMapSerializer() {
        }

        protected abstract T getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> var1);

        protected abstract byte getTypeByte();

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            encoder.writeByte(this.getTypeByte());
            ImmutableList entrySnapshots = ((AbstractIsolatedMap)value).getEntries();
            encoder.writeInt(entrySnapshots.size());
            for (MapEntrySnapshot entrySnapshot : entrySnapshots) {
                IsolatableSerializerRegistry.this.writeIsolatable(encoder, (Isolatable)entrySnapshot.getKey());
                IsolatableSerializerRegistry.this.writeIsolatable(encoder, (Isolatable)entrySnapshot.getValue());
            }
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            int size = decoder.readInt();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                Isolatable<?> key = IsolatableSerializerRegistry.this.readIsolatable(decoder);
                Isolatable<?> value = IsolatableSerializerRegistry.this.readIsolatable(decoder);
                MapEntrySnapshot entry = new MapEntrySnapshot(key, value);
                builder.add(entry);
            }
            return this.getIsolatedObject(builder.build());
        }
    }

    public class IsolatedEnumValueSnapshotSerializer
    implements IsolatableSerializer<IsolatedEnumValueSnapshot> {
        @Override
        public void write(Encoder encoder, IsolatedEnumValueSnapshot value) throws Exception {
            encoder.writeByte((byte)11);
            encoder.writeString(value.getClassName());
            encoder.writeString(value.getName());
        }

        @Override
        public IsolatedEnumValueSnapshot read(Decoder decoder) throws Exception {
            String className = decoder.readString();
            String name = decoder.readString();
            Class enumClass = (Class)Cast.uncheckedCast(IsolatableSerializerRegistry.this.fromClassName(className));
            return new IsolatedEnumValueSnapshot((Enum<?>)Enum.valueOf((Class)Cast.uncheckedCast(enumClass), name));
        }

        @Override
        public Class<IsolatedEnumValueSnapshot> getIsolatableClass() {
            return IsolatedEnumValueSnapshot.class;
        }
    }

    private static class NullValueSnapshotSerializer
    implements IsolatableSerializer<NullValueSnapshot> {
        private NullValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, NullValueSnapshot value) throws Exception {
            encoder.writeByte((byte)9);
        }

        @Override
        public NullValueSnapshot read(Decoder decoder) throws Exception {
            return NullValueSnapshot.INSTANCE;
        }

        @Override
        public Class<NullValueSnapshot> getIsolatableClass() {
            return NullValueSnapshot.class;
        }
    }

    private class IsolatedSerializedValueSnapshotSerializer
    implements IsolatableSerializer<IsolatedSerializedValueSnapshot> {
        private IsolatedSerializedValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedSerializedValueSnapshot value) throws Exception {
            encoder.writeByte((byte)10);
            encoder.writeString(value.getOriginalClass().getName());
            encoder.writeBinary(value.getImplementationHash().toByteArray());
            encoder.writeBinary(value.getValue());
        }

        @Override
        public IsolatedSerializedValueSnapshot read(Decoder decoder) throws Exception {
            String originalClassName = decoder.readString();
            Class originalClass = IsolatableSerializerRegistry.this.fromClassName(originalClassName);
            byte[] hashBytes = decoder.readBinary();
            byte[] serializedBytes = decoder.readBinary();
            return new IsolatedSerializedValueSnapshot(HashCode.fromBytes(hashBytes), serializedBytes, originalClass);
        }

        @Override
        public Class<IsolatedSerializedValueSnapshot> getIsolatableClass() {
            return IsolatedSerializedValueSnapshot.class;
        }
    }

    private static class FileValueSnapshotSerializer
    implements IsolatableSerializer<FileValueSnapshot> {
        private FileValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, FileValueSnapshot value) throws Exception {
            encoder.writeByte((byte)8);
            encoder.writeString((CharSequence)value.getValue());
        }

        @Override
        public FileValueSnapshot read(Decoder decoder) throws Exception {
            return new FileValueSnapshot(decoder.readString());
        }

        @Override
        public Class<FileValueSnapshot> getIsolatableClass() {
            return FileValueSnapshot.class;
        }
    }

    private class IsolatedManagedValueSerializer
    implements IsolatableSerializer<IsolatedManagedValue> {
        private IsolatedManagedValueSerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedManagedValue value) throws Exception {
            encoder.writeByte((byte)6);
            encoder.writeInt(value.getFactoryId());
            encoder.writeString(value.getTargetType().getName());
            Hashable state = value.getState();
            IsolatableSerializerRegistry.this.writeIsolatable(encoder, (Isolatable)state);
        }

        @Override
        public IsolatedManagedValue read(Decoder decoder) throws Exception {
            int factoryId = decoder.readInt();
            String publicClassName = decoder.readString();
            Class publicClass = IsolatableSerializerRegistry.this.fromClassName(publicClassName);
            Isolatable<?> state = IsolatableSerializerRegistry.this.readIsolatable(decoder);
            ManagedFactory factory = IsolatableSerializerRegistry.this.managedFactoryRegistry.lookup(factoryId);
            return new IsolatedManagedValue(publicClass, factory, state);
        }

        @Override
        public Class<IsolatedManagedValue> getIsolatableClass() {
            return IsolatedManagedValue.class;
        }
    }

    private class IsolatedImmutableManagedValueSerializer
    implements IsolatableSerializer<IsolatedImmutableManagedValue> {
        private IsolatedImmutableManagedValueSerializer() {
        }

        @Override
        public void write(Encoder encoder, IsolatedImmutableManagedValue value) throws Exception {
            encoder.writeByte((byte)7);
            encoder.writeInt(((Managed)value.getValue()).getFactoryId());
            encoder.writeString(((Managed)value.getValue()).publicType().getName());
            IsolatableSerializerRegistry.this.writeState(encoder, ((Managed)value.getValue()).unpackState());
        }

        @Override
        public IsolatedImmutableManagedValue read(Decoder decoder) throws Exception {
            int factoryId = decoder.readInt();
            String publicClassName = decoder.readString();
            Class publicClass = IsolatableSerializerRegistry.this.fromClassName(publicClassName);
            ManagedFactory factory = IsolatableSerializerRegistry.this.managedFactoryRegistry.lookup(factoryId);
            Managed managed = (Managed)Cast.uncheckedCast(factory.fromState(publicClass, IsolatableSerializerRegistry.this.readState(decoder)));
            return new IsolatedImmutableManagedValue(managed, IsolatableSerializerRegistry.this.managedFactoryRegistry);
        }

        @Override
        public Class<IsolatedImmutableManagedValue> getIsolatableClass() {
            return IsolatedImmutableManagedValue.class;
        }
    }

    private class AttributeDefinitionSnapshotSerializer
    implements IsolatableSerializer<AttributeDefinitionSnapshot> {
        private AttributeDefinitionSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, AttributeDefinitionSnapshot value) throws Exception {
            encoder.writeByte((byte)5);
            encoder.writeString(((Attribute)value.getValue()).getType().getName());
            encoder.writeString(((Attribute)value.getValue()).getName());
        }

        @Override
        public AttributeDefinitionSnapshot read(Decoder decoder) throws Exception {
            String className = decoder.readString();
            Class attributeClass = IsolatableSerializerRegistry.this.fromClassName(className);
            String name = decoder.readString();
            return new AttributeDefinitionSnapshot(Attribute.of(name, attributeClass), IsolatableSerializerRegistry.this.classLoaderHierarchyHasher);
        }

        @Override
        public Class<AttributeDefinitionSnapshot> getIsolatableClass() {
            return AttributeDefinitionSnapshot.class;
        }
    }

    private static class LongValueSnapshotSerializer
    implements IsolatableSerializer<LongValueSnapshot> {
        private LongValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, LongValueSnapshot value) throws Exception {
            encoder.writeByte((byte)4);
            encoder.writeLong((Long)value.getValue());
        }

        @Override
        public LongValueSnapshot read(Decoder decoder) throws Exception {
            return new LongValueSnapshot(decoder.readLong());
        }

        @Override
        public Class<LongValueSnapshot> getIsolatableClass() {
            return LongValueSnapshot.class;
        }
    }

    private static class IntegerValueSnapshotSerializer
    implements IsolatableSerializer<IntegerValueSnapshot> {
        private IntegerValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, IntegerValueSnapshot value) throws Exception {
            encoder.writeByte((byte)3);
            encoder.writeInt((Integer)value.getValue());
        }

        @Override
        public IntegerValueSnapshot read(Decoder decoder) throws Exception {
            return new IntegerValueSnapshot(decoder.readInt());
        }

        @Override
        public Class<IntegerValueSnapshot> getIsolatableClass() {
            return IntegerValueSnapshot.class;
        }
    }

    private static class ShortValueSnapshotSerializer
    implements IsolatableSerializer<ShortValueSnapshot> {
        private ShortValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, ShortValueSnapshot value) throws Exception {
            encoder.writeByte((byte)2);
            encoder.writeInt(((Short)value.getValue()).shortValue());
        }

        @Override
        public ShortValueSnapshot read(Decoder decoder) throws Exception {
            return new ShortValueSnapshot((short)decoder.readInt());
        }

        @Override
        public Class<ShortValueSnapshot> getIsolatableClass() {
            return ShortValueSnapshot.class;
        }
    }

    private static class BooleanValueSnapshotSerializer
    implements IsolatableSerializer<BooleanValueSnapshot> {
        private BooleanValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, BooleanValueSnapshot value) throws Exception {
            encoder.writeByte((byte)1);
            encoder.writeBoolean((Boolean)value.getValue());
        }

        @Override
        public BooleanValueSnapshot read(Decoder decoder) throws Exception {
            return new BooleanValueSnapshot(decoder.readBoolean());
        }

        @Override
        public Class<BooleanValueSnapshot> getIsolatableClass() {
            return BooleanValueSnapshot.class;
        }
    }

    private static class StringValueSnapshotSerializer
    implements IsolatableSerializer<StringValueSnapshot> {
        private StringValueSnapshotSerializer() {
        }

        @Override
        public void write(Encoder encoder, StringValueSnapshot value) throws Exception {
            encoder.writeByte((byte)0);
            encoder.writeString((CharSequence)value.getValue());
        }

        @Override
        public StringValueSnapshot read(Decoder decoder) throws Exception {
            return new StringValueSnapshot(decoder.readString());
        }

        @Override
        public Class<StringValueSnapshot> getIsolatableClass() {
            return StringValueSnapshot.class;
        }
    }

    private static interface IsolatableSerializer<T extends Isolatable<?>>
    extends Serializer<T> {
        public Class<T> getIsolatableClass();
    }
}

