/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelElementProjection;
import org.gradle.model.internal.inspect.ProjectionOnlyNodeInitializer;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionModelView;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

public class ScalarCollectionNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    public static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(List.class), ModelType.of(Set.class));

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(CollectionSchema<T, E> schema, NodeInitializerContext<T> context) {
        ModelType type = schema.getType();
        Class rawClass = type.getRawClass();
        ModelType rawCollectionType = ModelType.of(rawClass);
        if (TYPES.contains(rawCollectionType) && schema.getElementTypeSchema() instanceof ScalarValueSchema) {
            boolean writable;
            Optional<NodeInitializerContext.PropertyContext> propertyContext = context.getPropertyContextOptional();
            boolean bl = writable = !propertyContext.isPresent() || ((NodeInitializerContext.PropertyContext)propertyContext.get()).isWritable();
            if (schema.getType().getRawClass() == List.class) {
                return new ProjectionOnlyNodeInitializer(ScalarCollectionModelProjection.forList(schema.getElementType(), !writable), new ModelElementProjection((ModelType<?>)schema.getType()));
            }
            return new ProjectionOnlyNodeInitializer(ScalarCollectionModelProjection.forSet(schema.getElementType(), !writable), new ModelElementProjection((ModelType<?>)schema.getType()));
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.copyOf(TYPES);
    }

    private static class SetBackedCollection<T>
    extends MutationSafeCollection<T>
    implements Set<T> {
        public SetBackedCollection(Set<T> delegate, ModelViewState state, ModelType<T> elementType) {
            super(delegate, state, elementType);
        }
    }

    private static class ListBackedCollection<T>
    extends MutationSafeCollection<T>
    implements List<T> {
        public ListBackedCollection(List<T> delegate, ModelViewState state, ModelType<T> elementType) {
            super(delegate, state, elementType);
        }

        @Override
        public void add(int index, T element) {
            this.validateElementType(element);
            ((List)this.getDelegate(true)).add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            this.validateCollection(c);
            return ((List)this.getDelegate(true)).addAll(index, c);
        }

        @Override
        public T get(int index) {
            return (T)((List)this.getDelegate(false)).get(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.getDelegate(false)).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.getDelegate(false)).lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return ((List)this.getDelegate(false)).listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return ((List)this.getDelegate(false)).listIterator(index);
        }

        @Override
        public T remove(int index) {
            return (T)((List)this.getDelegate(true)).remove(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            this.validateElementType(element);
            return ((List)this.getDelegate(true)).set(index, element);
        }
    }

    private static abstract class MutationSafeCollection<T>
    implements Collection<T> {
        private final Collection<T> delegate;
        private final ModelViewState state;
        private final ModelType<T> elementType;

        public MutationSafeCollection(Collection<T> delegate, ModelViewState state, ModelType<T> elementType) {
            this.delegate = delegate;
            this.state = state;
            this.elementType = elementType;
        }

        public Collection<T> getDelegate(boolean forMutation) {
            if (forMutation) {
                this.state.assertCanMutate();
            }
            return this.delegate;
        }

        protected void validateElementType(Object o) {
            ModelType<?> obType;
            if (o != null && !(obType = ModelType.of(o.getClass())).equals(this.elementType)) {
                throw new IllegalArgumentException(String.format("Cannot add an element of type %s to a collection of %s", obType, this.elementType));
            }
        }

        protected void validateCollection(Collection<? extends T> c) {
            for (T element : c) {
                this.validateElementType(element);
            }
        }

        @Override
        public boolean add(T t) {
            this.validateElementType(t);
            return this.getDelegate(true).add(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.validateCollection(c);
            return this.getDelegate(true).addAll(c);
        }

        @Override
        public void clear() {
            this.getDelegate(true).clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegate(false).contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getDelegate(false).containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.getDelegate(false).equals(o);
        }

        @Override
        public int hashCode() {
            return this.getDelegate(false).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate(false).isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new MutationSafeIterator(this.getDelegate(false).iterator());
        }

        @Override
        public boolean remove(Object o) {
            return this.getDelegate(true).remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getDelegate(true).removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getDelegate(true).retainAll(c);
        }

        @Override
        public int size() {
            return this.getDelegate(false).size();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegate(false).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegate(false).toArray(a);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private final class MutationSafeIterator
        implements Iterator<T> {
            private final Iterator<T> delegate;

            private MutationSafeIterator(Iterator<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public T next() {
                return this.delegate.next();
            }

            @Override
            public void remove() {
                MutationSafeCollection.this.state.assertCanMutate();
                this.delegate.remove();
            }
        }
    }

    private static class SetModelView<T>
    extends ScalarCollectionModelView<T, Set<T>> {
        public SetModelView(ModelPath path, ModelType<T> elementType, MutableModelNode modelNode, ModelRuleDescriptor descriptor, boolean overwritable, boolean mutable) {
            super(path, ModelTypes.set(elementType), elementType, modelNode, descriptor, overwritable, mutable);
        }

        @Override
        protected Set<T> initialValue() {
            return new LinkedHashSet();
        }

        @Override
        protected Set<T> toMutationSafe(Collection<?> backingCollection) {
            return new SetBackedCollection((Set)Cast.uncheckedCast(backingCollection), (ModelViewState)this.state, this.elementType);
        }
    }

    private static class ListModelView<T>
    extends ScalarCollectionModelView<T, List<T>> {
        public ListModelView(ModelPath path, ModelType<T> elementType, MutableModelNode modelNode, ModelRuleDescriptor descriptor, boolean overwritable, boolean mutable) {
            super(path, ModelTypes.list(elementType), elementType, modelNode, descriptor, overwritable, mutable);
        }

        @Override
        protected List<T> initialValue() {
            return new LinkedList();
        }

        @Override
        protected List<T> toMutationSafe(Collection<?> backingCollection) {
            return new ListBackedCollection((List)Cast.uncheckedCast(backingCollection), (ModelViewState)this.state, this.elementType);
        }
    }

    private static abstract class ScalarCollectionModelProjection<E, C extends Collection<E>>
    extends TypeCompatibilityModelProjectionSupport<C> {
        public ScalarCollectionModelProjection(ModelType<C> type) {
            super(type);
        }

        @Override
        public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
            Collection values = (Collection)modelNodeInternal.asImmutable(this.getType(), null).getInstance();
            if (values == null) {
                return Optional.of((Object)"null");
            }
            return Optional.of((Object)values.toString());
        }

        protected abstract ScalarCollectionModelView<E, C> toView(MutableModelNode var1, ModelRuleDescriptor var2, boolean var3);

        public static <E> ScalarCollectionModelProjection<E, List<E>> forList(final ModelType<E> elementType, final boolean readOnly) {
            return new ScalarCollectionModelProjection<E, List<E>>(ModelTypes.list(elementType)){

                @Override
                protected ScalarCollectionModelView<E, List<E>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
                    return new ListModelView(modelNode.getPath(), elementType, modelNode, ruleDescriptor, readOnly, mutable);
                }
            };
        }

        public static <E> ScalarCollectionModelProjection<E, Set<E>> forSet(final ModelType<E> elementType, final boolean readOnly) {
            return new ScalarCollectionModelProjection<E, Set<E>>(ModelTypes.set(elementType)){

                @Override
                protected ScalarCollectionModelView<E, Set<E>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
                    return new SetModelView(modelNode.getPath(), elementType, modelNode, ruleDescriptor, readOnly, mutable);
                }
            };
        }
    }
}

