/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.io.InputStream;
import java.net.URI;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpException;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;

public class SftpResource
implements ExternalResourceReadResponse {
    private final SftpClientFactory clientFactory;
    private final ExternalResourceMetaData metaData;
    private final URI uri;
    private final PasswordCredentials credentials;
    private LockableSftpClient client;

    public SftpResource(SftpClientFactory clientFactory, ExternalResourceMetaData metaData, URI uri, PasswordCredentials credentials) {
        this.clientFactory = clientFactory;
        this.metaData = metaData;
        this.uri = uri;
        this.credentials = credentials;
    }

    @Override
    public InputStream openStream() {
        this.client = this.clientFactory.createSftpClient(this.uri, this.credentials);
        try {
            return this.client.getSftpClient().get(this.uri.getPath());
        }
        catch (SftpException e) {
            throw ResourceExceptions.getFailed(this.uri, e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isLocal() {
        return false;
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() {
        this.clientFactory.releaseSftpClient(this.client);
    }
}

