/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class DefaultFileHierarchySet {
    private static final EmptyFileHierarchySet EMPTY = new EmptyFileHierarchySet();

    public static FileHierarchySet of() {
        return EMPTY;
    }

    public static FileHierarchySet of(File rootDir) {
        return new PrefixFileSet(rootDir);
    }

    public static FileHierarchySet of(Iterable<File> rootDirs) {
        FileHierarchySet set = EMPTY;
        for (File rootDir : rootDirs) {
            set = set.plus(rootDir);
        }
        return set;
    }

    private static class Node {
        private final String prefix;
        private final List<Node> children;

        Node(String prefix) {
            this.prefix = prefix;
            this.children = ImmutableList.of();
        }

        public Node(String prefix, List<Node> children) {
            this.prefix = prefix;
            this.children = children;
        }

        Node plus(String path) {
            int maxPos = Math.min(this.prefix.length(), path.length());
            int prefixLen = this.sizeOfCommonPrefix(path, 0);
            if (prefixLen == maxPos) {
                if (this.prefix.length() == path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    return new Node(path);
                }
                if (this.prefix.length() < path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    int startNextSegment = prefixLen == 0 ? 0 : prefixLen + 1;
                    ArrayList<Node> merged = new ArrayList<Node>(this.children.size() + 1);
                    boolean matched = false;
                    for (Node child : this.children) {
                        if (child.sizeOfCommonPrefix(path, startNextSegment) > 0) {
                            merged.add(child.plus(path.substring(startNextSegment)));
                            matched = true;
                            continue;
                        }
                        merged.add(child);
                    }
                    if (!matched) {
                        merged.add(new Node(path.substring(startNextSegment)));
                    }
                    return new Node(this.prefix, merged);
                }
                return new Node(path);
            }
            String commonPrefix = this.prefix.substring(0, prefixLen);
            int newChildrenStartIndex = prefixLen == 0 ? 0 : prefixLen + 1;
            Node newThis = new Node(this.prefix.substring(newChildrenStartIndex), this.children);
            Node sibling = new Node(path.substring(newChildrenStartIndex));
            return new Node(commonPrefix, (List<Node>)ImmutableList.of((Object)newThis, (Object)sibling));
        }

        int sizeOfCommonPrefix(String path, int offset) {
            return FilePathUtil.sizeOfCommonPrefix(this.prefix, path, offset);
        }

        boolean isChildOfOrThis(String filePath, int offset) {
            int prefixLength;
            int endOfThisSegment;
            if (this.prefix.isEmpty()) {
                return true;
            }
            int pathLength = filePath.length();
            if (pathLength < (endOfThisSegment = (prefixLength = this.prefix.length()) + offset)) {
                return false;
            }
            int i = prefixLength - 1;
            int j = endOfThisSegment - 1;
            while (i >= 0) {
                if (this.prefix.charAt(i) != filePath.charAt(j)) {
                    return false;
                }
                --i;
                --j;
            }
            return endOfThisSegment == pathLength || filePath.charAt(endOfThisSegment) == File.separatorChar;
        }

        boolean contains(String filePath, int offset) {
            if (!this.isChildOfOrThis(filePath, offset)) {
                return false;
            }
            if (this.children.isEmpty()) {
                return true;
            }
            int startNextSegment = this.prefix.isEmpty() ? offset : offset + this.prefix.length() + 1;
            for (Node child : this.children) {
                if (!child.contains(filePath, startNextSegment)) continue;
                return true;
            }
            return false;
        }

        public void collect(int depth, List<String> prefixes) {
            if (depth == 0) {
                prefixes.add(this.prefix);
            } else {
                prefixes.add(depth + ":" + this.prefix.replace(File.separatorChar, '/'));
            }
            for (Node child : this.children) {
                child.collect(depth + 1, prefixes);
            }
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class PrefixFileSet
    implements FileHierarchySet {
        private final Node rootNode;

        PrefixFileSet(File rootDir) {
            String path = this.toPath(rootDir);
            this.rootNode = new Node(path);
        }

        PrefixFileSet(Node rootNode) {
            this.rootNode = rootNode;
        }

        @VisibleForTesting
        List<String> flatten() {
            ArrayList<String> prefixes = new ArrayList<String>();
            this.rootNode.collect(0, prefixes);
            return prefixes;
        }

        @Override
        public boolean contains(String path) {
            return this.rootNode.contains(path, 0);
        }

        @Override
        public boolean contains(File file) {
            return this.rootNode.contains(file.getPath(), 0);
        }

        @Override
        public FileHierarchySet plus(File rootDir) {
            return new PrefixFileSet(this.rootNode.plus(this.toPath(rootDir)));
        }

        private String toPath(File rootDir) {
            assert (rootDir.isAbsolute());
            String absolutePath = rootDir.getAbsolutePath();
            if (absolutePath.equals("/")) {
                absolutePath = "";
            } else if (absolutePath.endsWith(File.separator)) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            return absolutePath;
        }
    }

    private static class EmptyFileHierarchySet
    implements FileHierarchySet {
        private EmptyFileHierarchySet() {
        }

        @Override
        public boolean contains(File file) {
            return false;
        }

        @Override
        public boolean contains(String path) {
            return false;
        }

        @Override
        public FileHierarchySet plus(File rootDir) {
            return new PrefixFileSet(rootDir);
        }
    }
}

