/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.InterruptibleRunnable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.CurrentBuildOperationPreservingRunnable;

public class AsyncDispatch<T>
implements Dispatch<T>,
AsyncStoppable {
    private static final int MAX_QUEUE_SIZE = 200;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final LinkedList<T> queue = new LinkedList();
    private final Executor executor;
    private final int maxQueueSize;
    private final Map<Dispatch<?>, InterruptibleRunnable> dispatchers = Maps.newHashMap();
    private State state;

    public AsyncDispatch(Executor executor) {
        this(executor, null, 200);
    }

    public AsyncDispatch(Executor executor, Dispatch<? super T> dispatch, int maxQueueSize) {
        this.executor = executor;
        this.maxQueueSize = maxQueueSize;
        this.state = State.Init;
        if (dispatch != null) {
            this.dispatchTo(dispatch);
        }
    }

    public void dispatchTo(final Dispatch<? super T> dispatch) {
        InterruptibleRunnable dispatcher = new InterruptibleRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncDispatch.this.dispatchMessages(dispatch);
                }
                finally {
                    AsyncDispatch.this.onDispatchThreadExit(dispatch);
                }
            }
        });
        this.onDispatchThreadStart(dispatch, dispatcher);
        this.executor.execute(new CurrentBuildOperationPreservingRunnable(dispatcher));
    }

    private void dispatchMessages(Dispatch<? super T> dispatch) {
        T message;
        while ((message = this.waitForNextMessage()) != null) {
            dispatch.dispatch(message);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T waitForNextMessage() {
        this.lock.lock();
        try {
            boolean interrupted = false;
            while (this.state != State.Stopped && this.queue.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (!this.queue.isEmpty()) {
                T message = this.queue.remove();
                this.condition.signalAll();
                T t = message;
                return t;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private void onDispatchThreadStart(Dispatch<? super T> dispatch, InterruptibleRunnable dispatcher) {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("This dispatch has been stopped.");
            }
            this.dispatchers.put(dispatch, dispatcher);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onDispatchThreadExit(Dispatch<? super T> dispatch) {
        this.lock.lock();
        try {
            this.dispatchers.remove(dispatch);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T message) {
        this.lock.lock();
        try {
            boolean interrupted = false;
            while (this.state != State.Stopped && this.queue.size() >= this.maxQueueSize) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.state == State.Stopped) {
                throw new IllegalStateException("Cannot dispatch message, as this message dispatch has been stopped. Message: " + message);
            }
            this.queue.add(message);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        this.setState(State.Stopped);
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.setState(State.Stopped);
            this.waitForAllMessages();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForAllMessages() {
        boolean interrupted = false;
        while (!this.dispatchers.isEmpty()) {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                for (InterruptibleRunnable dispatcher : this.dispatchers.values()) {
                    dispatcher.interrupt();
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (!this.queue.isEmpty()) {
            throw new IllegalStateException("Cannot wait for messages to be dispatched, as there are no dispatch threads running.");
        }
    }

    private static enum State {
        Init,
        Stopped;

    }
}

