/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.http.internal.HttpBuildCacheRequestCustomizer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.apache.http.HttpEntity;
import org.gradle.internal.impldep.org.apache.http.HttpRequest;
import org.gradle.internal.impldep.org.apache.http.StatusLine;
import org.gradle.internal.impldep.org.apache.http.client.ClientProtocolException;
import org.gradle.internal.impldep.org.apache.http.client.NonRepeatableRequestException;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpGet;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpPut;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpRequestBase;
import org.gradle.internal.impldep.org.apache.http.entity.AbstractHttpEntity;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCacheService
implements BuildCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCacheService.class);
    static final String BUILD_CACHE_CONTENT_TYPE = "application/vnd.gradle.build-cache-artifact.v1";
    private static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of((Object)305, (Object)400, (Object)401, (Object)403, (Object)407, (Object)405, (Object[])new Integer[]{406, 411, 415, 417, 426, 505, 511});
    private final URI root;
    private final HttpClientHelper httpClientHelper;
    private final HttpBuildCacheRequestCustomizer requestCustomizer;

    public HttpBuildCacheService(HttpClientHelper httpClientHelper, URI url, HttpBuildCacheRequestCustomizer requestCustomizer) {
        this.requestCustomizer = requestCustomizer;
        if (!url.getPath().endsWith("/")) {
            throw new IllegalArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = url;
        this.httpClientHelper = httpClientHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        URI uri = this.root.resolve("./" + key.getHashCode());
        HttpGet httpGet = new HttpGet(uri);
        httpGet.addHeader("Accept", "application/vnd.gradle.build-cache-artifact.v1, */*");
        this.requestCustomizer.customize((HttpRequest)httpGet);
        try (HttpClientResponse response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpGet);){
            int statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
            }
            if (this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                reader.readFrom(response.getContent());
                boolean bl = true;
                return bl;
            }
            if (statusCode == 404) {
                boolean bl = false;
                return bl;
            }
            String defaultMessage = String.format("Loading entry from '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
            if (this.isRedirect(statusCode)) {
                boolean bl = this.handleRedirect(uri, response, statusCode, defaultMessage, "loading entry from");
                return bl;
            }
            boolean bl = this.throwHttpStatusCodeException(statusCode, defaultMessage);
            return bl;
        }
        catch (IOException e) {
            throw HttpBuildCacheService.wrap(e);
        }
    }

    private boolean handleRedirect(URI uri, HttpClientResponse response, int statusCode, String defaultMessage, String action) {
        String locationHeader = response.getHeader("Location");
        if (locationHeader == null) {
            return this.throwHttpStatusCodeException(statusCode, defaultMessage);
        }
        try {
            throw new BuildCacheException(String.format("Received unexpected redirect (HTTP %d) to %s when " + action + " '%s'. Ensure the configured URL for the remote build cache is correct.", statusCode, HttpBuildCacheService.safeUri(new URI(locationHeader)), HttpBuildCacheService.safeUri(uri)));
        }
        catch (URISyntaxException e) {
            return this.throwHttpStatusCodeException(statusCode, defaultMessage);
        }
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    @Override
    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Content-Type", BUILD_CACHE_CONTENT_TYPE);
        this.requestCustomizer.customize((HttpRequest)httpPut);
        httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return output.getSize();
            }

            public InputStream getContent() {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                output.writeTo(outstream);
            }

            public boolean isStreaming() {
                return false;
            }
        });
        try (HttpClientResponse response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpPut);){
            int statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
            }
            if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                String defaultMessage = String.format("Storing entry at '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
                if (this.isRedirect(statusCode)) {
                    this.handleRedirect(uri, response, statusCode, defaultMessage, "storing entry at");
                } else {
                    this.throwHttpStatusCodeException(statusCode, defaultMessage);
                }
            }
        }
        catch (ClientProtocolException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NonRepeatableRequestException) {
                throw HttpBuildCacheService.wrap(cause.getCause());
            }
            throw HttpBuildCacheService.wrap(cause);
        }
        catch (IOException e) {
            throw HttpBuildCacheService.wrap(e);
        }
    }

    private static BuildCacheException wrap(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new BuildCacheException(e.getMessage(), e);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean throwHttpStatusCodeException(int statusCode, String message) {
        if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
            throw new UncheckedIOException(message);
        }
        throw new BuildCacheException(message);
    }

    @Override
    public void close() throws IOException {
        this.httpClientHelper.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

