/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc.internal;

import org.gradle.api.GradleException;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.external.javadoc.internal.JavadocExecHandleBuilder;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavadocGenerator
implements Compiler<JavadocSpec> {
    private static final Logger LOG = LoggerFactory.getLogger(JavadocGenerator.class);
    private final ExecActionFactory execActionFactory;

    public JavadocGenerator(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    @Override
    public WorkResult execute(JavadocSpec spec) {
        JavadocExecHandleBuilder javadocExecHandleBuilder = new JavadocExecHandleBuilder(this.execActionFactory);
        javadocExecHandleBuilder.setExecutable(spec.getExecutable());
        javadocExecHandleBuilder.execDirectory(spec.getWorkingDir()).options(spec.getOptions()).optionsFile(spec.getOptionsFile());
        ExecAction execAction = javadocExecHandleBuilder.getExecHandle();
        if (spec.isIgnoreFailures()) {
            execAction.setIgnoreExitValue(true);
        }
        try {
            execAction.execute();
        }
        catch (ExecException e) {
            LOG.info("Problems generating Javadoc.\n  Command line issued: " + execAction.getCommandLine() + "\n  Generated Javadoc options file has following contents:\n------\n{}------", (Object)GFileUtils.readFileQuietly(spec.getOptionsFile()));
            throw new GradleException(String.format("Javadoc generation failed. Generated Javadoc options file (useful for troubleshooting): '%s'", spec.getOptionsFile()), e);
        }
        return WorkResults.didWork(true);
    }
}

