/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationReportingCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.SourceClassesMappingFileAccessor;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.FileNameDerivingClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.IncrementalCompilationResult;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private final CompileOptions compileOptions;
    private JavaToolChain toolChain;
    private final FileCollection stableSources = this.getProject().files(() -> new Object[]{this.getSource(), this.getSources()});
    private final ModularitySpec modularity;
    private File sourceClassesMappingFile;

    public JavaCompile() {
        Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        this.compileOptions = objects.newInstance(CompileOptions.class, new Object[0]);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(this.compileOptions, this.getOutputs());
        this.modularity = objects.newInstance(DefaultModularitySpec.class, new Object[0]);
    }

    @Override
    @ReplacedBy(value="stableSources")
    public FileTree getSource() {
        return super.getSource();
    }

    @Deprecated
    @Internal
    protected FileTree getSources() {
        return this.getProjectLayout().files(new Object[0]).getAsFileTree();
    }

    @Nested
    public JavaToolChain getToolChain() {
        if (this.toolChain != null) {
            return this.toolChain;
        }
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    public void setToolChain(JavaToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @Deprecated
    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        ((DeprecationMessageBuilder)DeprecationLogger.deprecate("Extending the JavaCompile task").withAdvice("Configure the task instead.")).willBeRemovedInGradle7().undocumented().nagUser();
        this.compile((InputChanges)((Object)inputs));
    }

    @Incubating
    @TaskAction
    protected void compile(InputChanges inputs) {
        DefaultJavaCompileSpec spec = this.createSpec();
        if (!this.compileOptions.isIncremental()) {
            this.performFullCompilation(spec);
        } else {
            this.performIncrementalCompilation(inputs, spec);
        }
    }

    private void performIncrementalCompilation(InputChanges inputs, DefaultJavaCompileSpec spec) {
        SourceFileClassNameConverter sourceFileClassNameConverter;
        Multimap<String, String> oldMappings;
        boolean isUsingCliCompiler = this.isUsingCliCompiler(spec);
        File sourceClassesMappingFile = this.getSourceClassesMappingFile();
        if (isUsingCliCompiler) {
            oldMappings = null;
            sourceFileClassNameConverter = new FileNameDerivingClassNameConverter();
        } else {
            oldMappings = SourceClassesMappingFileAccessor.readSourceClassesMappingFile(sourceClassesMappingFile);
            sourceFileClassNameConverter = new DefaultSourceFileClassNameConverter(oldMappings);
        }
        sourceClassesMappingFile.delete();
        spec.getCompileOptions().setIncrementalCompilationMappingFile(sourceClassesMappingFile);
        Compiler<JavaCompileSpec> compiler = this.createCompiler(spec);
        compiler = this.makeIncremental(inputs, sourceFileClassNameConverter, (CleaningJavaCompiler<JavaCompileSpec>)compiler, this.getStableSources().getAsFileTree());
        WorkResult workResult = this.performCompilation(spec, compiler);
        if (workResult instanceof IncrementalCompilationResult && !isUsingCliCompiler) {
            SourceClassesMappingFileAccessor.mergeIncrementalMappingsIntoOldMappings(sourceClassesMappingFile, this.getStableSources(), inputs, oldMappings);
        }
    }

    private Compiler<JavaCompileSpec> makeIncremental(InputChanges inputs, SourceFileClassNameConverter sourceFileClassNameConverter, CleaningJavaCompiler<JavaCompileSpec> compiler, FileTree sources) {
        return this.getIncrementalCompilerFactory().makeIncremental(compiler, this.getPath(), sources, this.createRecompilationSpec(inputs, sourceFileClassNameConverter, sources));
    }

    private JavaRecompilationSpecProvider createRecompilationSpec(InputChanges inputs, SourceFileClassNameConverter sourceFileClassNameConverter, FileTree sources) {
        return new JavaRecompilationSpecProvider(this.getDeleter(), this.getServices().get(FileOperations.class), sources, inputs.isIncremental(), () -> inputs.getFileChanges(this.getStableSources()).iterator(), sourceFileClassNameConverter);
    }

    private boolean isUsingCliCompiler(DefaultJavaCompileSpec spec) {
        return CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass());
    }

    private void performFullCompilation(DefaultJavaCompileSpec spec) {
        spec.setSourceFiles(this.getStableSources());
        CleaningJavaCompiler<JavaCompileSpec> compiler = this.createCompiler(spec);
        this.performCompilation(spec, compiler);
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    private CleaningJavaCompiler<JavaCompileSpec> createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = CompilerUtil.castCompiler(((JavaToolChainInternal)this.getToolChain()).select(this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler<JavaCompileSpec>(javaCompiler, this.getOutputs(), this.getDeleter());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return new DefaultJavaPlatform(JavaVersion.toVersion(this.getTargetCompatibility()));
    }

    @LocalState
    @Incubating
    protected File getSourceClassesMappingFile() {
        if (this.sourceClassesMappingFile == null) {
            File tmpDir = this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
            this.sourceClassesMappingFile = new File(tmpDir, "source-classes-mapping.txt");
        }
        return this.sourceClassesMappingFile;
    }

    private WorkResult performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = new CompileJavaBuildOperationReportingCompiler(this, compiler, this.getServices().get(BuildOperationExecutor.class)).execute(spec);
        this.setDidWork(result.getDidWork());
        return result;
    }

    private DefaultJavaCompileSpec createSpec() {
        List<File> sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)this.getStableSources().getAsFileTree());
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        boolean isModule = JavaModuleDetector.isModuleSource((Boolean)this.modularity.getInferModulePath().get(), sourcesRoots);
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)javaModuleDetector.inferClasspath(isModule, this.getClasspath())));
        spec.setModulePath((List<File>)ImmutableList.copyOf((Iterable)javaModuleDetector.inferModulePath(isModule, this.getClasspath())));
        if (isModule) {
            this.compileOptions.setSourcepath(this.getProjectLayout().files(sourcesRoots));
        }
        spec.setAnnotationProcessorPath((List<File>)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        spec.setSourcesRoots(sourcesRoots);
        if (((JavaToolChainInternal)this.getToolChain()).getJavaVersion().compareTo(JavaVersion.VERSION_1_8) < 0) {
            spec.getCompileOptions().setHeaderOutputDirectory(null);
        }
        return spec;
    }

    @Incubating
    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Override
    @CompileClasspath
    @Incremental
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Incubating
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }
}

