/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingInputs;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class SnapshotTaskInputsBuildOperationResult
implements SnapshotTaskInputsBuildOperationType.Result,
CustomOperationTraceSerialization {
    @VisibleForTesting
    final CachingState cachingState;

    public SnapshotTaskInputsBuildOperationResult(CachingState cachingState) {
        this.cachingState = cachingState;
    }

    @Override
    public Map<String, byte[]> getInputValueHashesBytes() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, Map<String, byte[]>>(){

            @Override
            @Nullable
            public Map<String, byte[]> apply(CachingInputs cachingInputs) {
                ImmutableSortedMap<String, HashCode> inputValueFingerprints = cachingInputs.getInputValueFingerprints();
                if (inputValueFingerprints.isEmpty()) {
                    return null;
                }
                return Maps.transformValues(inputValueFingerprints, (Function)new Function<HashCode, byte[]>(){

                    public byte[] apply(HashCode input) {
                        return input.toByteArray();
                    }
                });
            }
        }).orElse(null);
    }

    @Override
    public void visitInputFileProperties(final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
        this.cachingState.getInputs().ifPresent(new Consumer<CachingInputs>(){

            @Override
            public void accept(CachingInputs inputs) {
                State state = new State(visitor);
                for (Map.Entry entry : inputs.getInputFileFingerprints().entrySet()) {
                    CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
                    state.propertyName = (String)entry.getKey();
                    state.propertyHash = fingerprint.getHash();
                    state.propertyNormalizationStrategyIdentifier = fingerprint.getStrategyIdentifier();
                    state.fingerprints = fingerprint.getFingerprints();
                    visitor.preProperty(state);
                    fingerprint.accept(state);
                    visitor.postProperty();
                }
            }
        });
    }

    @Override
    @Nullable
    public Set<String> getInputPropertiesLoadedByUnknownClassLoader() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, Set<String>>(){

            @Override
            @Nullable
            public Set<String> apply(CachingInputs inputs) {
                ImmutableSortedSet<String> invalidInputProperties = inputs.getNonCacheableInputProperties();
                if (invalidInputProperties.isEmpty()) {
                    return null;
                }
                return invalidInputProperties;
            }
        }).orElse(null);
    }

    @Override
    public byte[] getClassLoaderHashBytes() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, byte[]>(){

            @Override
            @Nullable
            public byte[] apply(CachingInputs inputs) {
                ImplementationSnapshot implementation = inputs.getImplementation();
                if (implementation.getClassLoaderHash() == null) {
                    return null;
                }
                return implementation.getClassLoaderHash().toByteArray();
            }
        }).orElse(null);
    }

    @Override
    public List<byte[]> getActionClassLoaderHashesBytes() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, List<byte[]>>(){

            @Override
            @Nullable
            public List<byte[]> apply(CachingInputs inputs) {
                ImmutableList<ImplementationSnapshot> additionalImplementations = inputs.getAdditionalImplementations();
                if (additionalImplementations.isEmpty()) {
                    return null;
                }
                return Lists.transform(additionalImplementations, (Function)new Function<ImplementationSnapshot, byte[]>(){

                    public byte[] apply(ImplementationSnapshot input) {
                        return input.getClassLoaderHash() == null ? null : input.getClassLoaderHash().toByteArray();
                    }
                });
            }
        }).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getActionClassNames() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, List<String>>(){

            @Override
            @Nullable
            public List<String> apply(CachingInputs inputs) {
                ImmutableList<ImplementationSnapshot> additionalImplementations = inputs.getAdditionalImplementations();
                if (additionalImplementations.isEmpty()) {
                    return null;
                }
                return Lists.transform(additionalImplementations, (Function)new Function<ImplementationSnapshot, String>(){

                    public String apply(ImplementationSnapshot input) {
                        return input.getTypeName();
                    }
                });
            }
        }).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getOutputPropertyNames() {
        return this.cachingState.getInputs().map(new java.util.function.Function<CachingInputs, List<String>>(){

            @Override
            @Nullable
            public List<String> apply(CachingInputs inputs) {
                ImmutableSortedSet<String> outputPropertyNames = inputs.getOutputProperties();
                if (outputPropertyNames.isEmpty()) {
                    return null;
                }
                return outputPropertyNames.asList();
            }
        }).orElse(null);
    }

    @Override
    public byte[] getHashBytes() {
        return this.cachingState.getKey().map(new java.util.function.Function<BuildCacheKey, byte[]>(){

            @Override
            public byte[] apply(BuildCacheKey cacheKey) {
                return cacheKey.toByteArray();
            }
        }).orElse(null);
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        Function<byte[], String> bytesToString = new Function<byte[], String>(){

            @Nullable
            public String apply(@Nullable byte[] input) {
                if (input == null) {
                    return null;
                }
                return HashCode.fromBytes(input).toString();
            }
        };
        List<byte[]> actionClassLoaderHashesBytes = this.getActionClassLoaderHashesBytes();
        if (actionClassLoaderHashesBytes != null) {
            model.put("actionClassLoaderHashes", Lists.transform(this.getActionClassLoaderHashesBytes(), (Function)bytesToString));
        } else {
            model.put("actionClassLoaderHashes", null);
        }
        model.put("actionClassNames", this.getActionClassNames());
        byte[] hashBytes = this.getHashBytes();
        if (hashBytes != null) {
            model.put("hash", HashCode.fromBytes(hashBytes).toString());
        } else {
            model.put("hash", null);
        }
        byte[] classLoaderHashBytes = this.getClassLoaderHashBytes();
        if (classLoaderHashBytes != null) {
            model.put("classLoaderHash", HashCode.fromBytes(classLoaderHashBytes).toString());
        } else {
            model.put("classLoaderHash", null);
        }
        model.put("inputFileProperties", this.fileProperties());
        model.put("inputPropertiesLoadedByUnknownClassLoader", this.getInputPropertiesLoadedByUnknownClassLoader());
        Map<String, byte[]> inputValueHashesBytes = this.getInputValueHashesBytes();
        if (inputValueHashesBytes != null) {
            model.put("inputValueHashes", Maps.transformEntries(inputValueHashesBytes, (Maps.EntryTransformer)new Maps.EntryTransformer<String, byte[], String>(){

                @Nullable
                public String transformEntry(@Nullable String key, @Nullable byte[] value) {
                    if (value == null) {
                        return null;
                    }
                    return HashCode.fromBytes(value).toString();
                }
            }));
        } else {
            model.put("inputValueHashes", null);
        }
        model.put("outputPropertyNames", this.getOutputPropertyNames());
        return model;
    }

    protected Map<String, Object> fileProperties() {
        final TreeMap<String, Object> fileProperties = new TreeMap<String, Object>();
        this.visitInputFileProperties(new SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor(){
            Property property;
            Deque<DirEntry> dirStack = new ArrayDeque<DirEntry>();

            @Override
            public void preProperty(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                this.property = new Property(HashCode.fromBytes(state.getPropertyHashBytes()).toString(), state.getPropertyNormalizationStrategyName());
                fileProperties.put(state.getPropertyName(), this.property);
            }

            @Override
            public void preRoot(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
            }

            @Override
            public void preDirectory(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                boolean isRoot = this.dirStack.isEmpty();
                DirEntry dir = new DirEntry(isRoot ? state.getPath() : state.getName());
                if (isRoot) {
                    this.property.roots.add(dir);
                } else {
                    this.dirStack.peek().children.add(dir);
                }
                this.dirStack.push(dir);
            }

            @Override
            public void file(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                boolean isRoot = this.dirStack.isEmpty();
                FileEntry file = new FileEntry(isRoot ? state.getPath() : state.getName(), HashCode.fromBytes(state.getHashBytes()).toString());
                if (isRoot) {
                    this.property.roots.add(file);
                } else {
                    this.dirStack.peek().children.add(file);
                }
            }

            @Override
            public void postDirectory() {
                this.dirStack.pop();
            }

            @Override
            public void postRoot() {
            }

            @Override
            public void postProperty() {
            }

            class DirEntry
            extends Entry {
                private final List<Entry> children;

                DirEntry(String path) {
                    super(path);
                    this.children = new ArrayList<Entry>();
                }

                public Collection<Entry> getChildren() {
                    return this.children;
                }
            }

            class FileEntry
            extends Entry {
                private final String hash;

                FileEntry(String path, String hash) {
                    super(path);
                    this.hash = hash;
                }

                public String getHash() {
                    return this.hash;
                }
            }

            abstract class Entry {
                private final String path;

                public Entry(String path) {
                    this.path = path;
                }

                public String getPath() {
                    return this.path;
                }
            }

            class Property {
                private final String hash;
                private final String normalization;
                private final List<Entry> roots = new ArrayList<Entry>();

                public Property(String hash, String normalization) {
                    this.hash = hash;
                    this.normalization = normalization;
                }

                public String getHash() {
                    return this.hash;
                }

                public String getNormalization() {
                    return this.normalization;
                }

                public Collection<Entry> getRoots() {
                    return this.roots;
                }
            }
        });
        return fileProperties;
    }

    @NonNullApi
    private static class State
    implements SnapshotTaskInputsBuildOperationType.Result.VisitState,
    FileSystemSnapshotVisitor {
        final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor;
        Map<String, FileSystemLocationFingerprint> fingerprints;
        String propertyName;
        HashCode propertyHash;
        String propertyNormalizationStrategyIdentifier;
        String name;
        String path;
        HashCode hash;
        int depth;

        public State(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public byte[] getPropertyHashBytes() {
            return this.propertyHash.toByteArray();
        }

        @Override
        public String getPropertyNormalizationStrategyName() {
            return this.propertyNormalizationStrategyIdentifier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public byte[] getHashBytes() {
            return this.hash.toByteArray();
        }

        @Override
        public boolean preVisitDirectory(CompleteDirectorySnapshot physicalSnapshot) {
            this.path = physicalSnapshot.getAbsolutePath();
            this.name = physicalSnapshot.getName();
            this.hash = null;
            if (this.depth++ == 0) {
                this.visitor.preRoot(this);
            }
            this.visitor.preDirectory(this);
            return true;
        }

        @Override
        public void visitFile(CompleteFileSystemLocationSnapshot snapshot) {
            boolean isRoot;
            this.path = snapshot.getAbsolutePath();
            this.name = snapshot.getName();
            FileSystemLocationFingerprint fingerprint = this.fingerprints.get(this.path);
            if (fingerprint == null) {
                return;
            }
            this.hash = fingerprint.getNormalizedContentHash();
            boolean bl = isRoot = this.depth == 0;
            if (isRoot) {
                this.visitor.preRoot(this);
            }
            this.visitor.file(this);
            if (isRoot) {
                this.visitor.postRoot();
            }
        }

        @Override
        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.visitor.postDirectory();
            if (--this.depth == 0) {
                this.visitor.postRoot();
            }
        }
    }
}

