/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.nio.file.Path;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeferredUtil;

public class UnpackingVisitor {
    private final FileCollectionResolveContext context;
    private final PathToFileResolver resolver;

    public UnpackingVisitor(FileCollectionResolveContext context, PathToFileResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }

    public void add(@Nullable Object element) {
        if (element instanceof FileCollection) {
            this.context.add(element);
            return;
        }
        if (element instanceof DirectoryTree) {
            this.context.add(element);
            return;
        }
        if (element instanceof ProviderInternal) {
            ProviderInternal provider = (ProviderInternal)element;
            if (!this.context.maybeAdd(provider)) {
                this.add(provider.get());
            }
            return;
        }
        if ((element instanceof Buildable || element instanceof TaskDependencyContainer) && this.context.maybeAdd(element)) {
            return;
        }
        if (element instanceof Task) {
            this.context.add(((Task)element).getOutputs().getFiles());
        } else if (element instanceof TaskOutputs) {
            this.context.add(((TaskOutputs)element).getFiles());
        } else if (DeferredUtil.isNestableDeferred(element)) {
            Object deferredResult = DeferredUtil.unpackNestableDeferred(element);
            if (deferredResult != null) {
                this.add(deferredResult);
            }
        } else if (element instanceof Path) {
            this.context.add(element, this.resolver);
        } else if (element instanceof Iterable) {
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                this.add(item);
            }
        } else if (element instanceof Object[]) {
            Object[] array;
            for (Object value : array = (Object[])element) {
                this.add(value);
            }
        } else if (element != null) {
            this.context.add(element, this.resolver);
        }
    }
}

