/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class CompositeFileCollection
extends AbstractFileCollection
implements FileCollectionContainer,
TaskDependencyContainer {
    public CompositeFileCollection(Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
    }

    public CompositeFileCollection() {
    }

    @Override
    public Set<File> getFiles() {
        return CompositeFileCollection.getFiles(this.getSourceCollections());
    }

    @Override
    public Iterator<File> iterator() {
        List<? extends FileCollectionInternal> sourceCollections = this.getSourceCollections();
        switch (sourceCollections.size()) {
            case 0: {
                return Collections.emptyIterator();
            }
            case 1: {
                return sourceCollections.get(0).iterator();
            }
        }
        return CompositeFileCollection.getFiles(sourceCollections).iterator();
    }

    private static Set<File> getFiles(List<? extends FileCollectionInternal> sourceCollections) {
        switch (sourceCollections.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return sourceCollections.get(0).getFiles();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (FileCollection fileCollection : sourceCollections) {
            builder.addAll((Iterable)fileCollection);
        }
        return builder.build();
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(builder, nodeName, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new CompositeFileCollection(this.patternSetFactory){

            @Override
            public void visitContents(FileCollectionResolveContext context) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    context.add(fileCollection.filter(filterSpec));
                }
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.visitDependencies(context);
            }

            @Override
            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        BuildDependenciesOnlyFileCollectionResolveContext fileContext = new BuildDependenciesOnlyFileCollectionResolveContext(context);
        this.visitContents(fileContext);
    }

    protected List<? extends FileCollectionInternal> getSourceCollections() {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(this.patternSetFactory);
        this.visitContents(context);
        return context.resolveAsFileCollections();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        for (FileCollectionInternal fileCollectionInternal : this.getSourceCollections()) {
            fileCollectionInternal.visitStructure(visitor);
        }
    }
}

