/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileOrUriNotationConverter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.FileUtils;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.DeferredUtil;

public abstract class AbstractFileResolver
implements FileResolver {
    private final NotationParser<Object, Object> fileNotationParser = FileOrUriNotationConverter.parser();

    protected AbstractFileResolver() {
    }

    public FileResolver withBaseDir(Object path) {
        return new BaseDirFileResolver(this.resolve(path));
    }

    @Override
    public FileResolver newResolver(File baseDir) {
        return new BaseDirFileResolver(baseDir);
    }

    @Override
    public File resolve(Object path) {
        return this.resolve(path, PathValidation.NONE);
    }

    @Override
    public NotationParser<Object, File> asNotationParser() {
        return new NotationParser<Object, File>(){

            @Override
            public File parseNotation(Object notation) throws UnsupportedNotationException {
                return AbstractFileResolver.this.resolve(notation, PathValidation.NONE);
            }

            @Override
            public void describe(DiagnosticsVisitor visitor) {
                visitor.candidate("Anything that can be converted to a file, as per Project.file()");
            }
        };
    }

    @Override
    public File resolve(Object path, PathValidation validation) {
        File file = this.doResolve(path);
        file = FileUtils.normalize(file);
        this.validate(file, validation);
        return file;
    }

    @Override
    public URI resolveUri(Object path) {
        return this.convertObjectToURI(path);
    }

    protected abstract File doResolve(Object var1);

    protected URI convertObjectToURI(Object path) {
        Object object = DeferredUtil.unpack(path);
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return this.resolve(converted).toURI();
        }
        return (URI)converted;
    }

    @Nullable
    protected File convertObjectToFile(Object path) {
        Object object = DeferredUtil.unpack(path);
        if (object == null) {
            return null;
        }
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return (File)converted;
        }
        throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", converted));
    }

    protected void validate(File file, PathValidation validation) {
        switch (validation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }
}

