/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyUnwrapper
extends AbstractUnwrapper<Context> {
    public GroovyUnwrapper(@NotNull String description) {
        super(description);
    }

    protected Context createContext() {
        return new Context();
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        return parent2 instanceof GrIfStatement && element == ((GrIfStatement)parent2).getElseBranch();
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        List res = super.unwrap(editor, element);
        for (PsiElement e : res) {
            if (!com.intellij.psi.impl.PsiImplUtil.isLeafElementOfType((PsiElement)e, (IElementType)GroovyTokenTypes.mNLS)) continue;
            CodeEditUtil.setNodeGenerated((ASTNode)e.getNode(), (boolean)true);
        }
        return res;
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        public void extractFromBlockOrSingleStatement(GrStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof GrBlockStatement) {
                this.extractFromCodeBlock(((GrBlockStatement)block).getBlock(), from);
            } else if (block != null) {
                this.extract(block, block, from);
            }
        }

        public void extractFromCodeBlock(GrCodeBlock block, PsiElement from) throws IncorrectOperationException {
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            if (block == null) {
                return;
            }
            PsiElement rBrace = block.getRBrace();
            PsiElement lBrace = block.getLBrace();
            if (lBrace == null) {
                firstBodyElement = null;
            } else {
                firstBodyElement = lBrace.getNextSibling();
                if (firstBodyElement == rBrace) {
                    firstBodyElement = null;
                }
            }
            if (rBrace == null) {
                lastBodyElement = null;
            } else {
                lastBodyElement = rBrace.getPrevSibling();
                if (lastBodyElement == lBrace) {
                    lastBodyElement = null;
                }
            }
            this.extract(firstBodyElement, lastBodyElement, from);
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return PsiImplUtil.isWhiteSpaceOrNls(element);
        }

        public void setElseBranch(GrIfStatement ifStatement, GrStatement elseBranch) throws IncorrectOperationException {
            GrStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.replaceElseBranch(Context.copyElement(elseBranch));
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract(toExtract);
        }

        private static GrStatement copyElement(GrStatement e) throws IncorrectOperationException {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(e.getProject());
            return factory.createStatementFromText(e.getText(), null);
        }
    }
}

