/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyElseUnwrapperBase;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyElseRemover
extends GroovyElseUnwrapperBase {
    public GroovyElseRemover() {
        super(CodeInsightBundle.message((String)"remove.else", (Object[])new Object[0]));
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return ((GrIfStatement)e.getParent()).getElseBranch();
    }

    @Override
    protected void unwrapElseBranch(GrStatement branch, PsiElement parent2, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        if (branch instanceof GrIfStatement) {
            GroovyElseRemover.deleteSelectedElseIf((GrIfStatement)branch, context);
        } else {
            context.delete(branch);
        }
    }

    private static void deleteSelectedElseIf(GrIfStatement selectedBranch, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        GrIfStatement parentIf = (GrIfStatement)selectedBranch.getParent();
        GrStatement childElse = selectedBranch.getElseBranch();
        if (childElse == null) {
            context.delete(selectedBranch);
            return;
        }
        context.setElseBranch(parentIf, childElse);
    }
}

