/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStatic;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStaticIntention$sam$com_intellij_openapi_util_Condition$0;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeChecker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "checkUnresolvedReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isCSAnnotated", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.groovy"})
public final class ConvertToStaticIntention
extends Intention {
    @Override
    @NotNull
    public String getText() {
        return GroovyRefactoringBundle.message("intention.converting.to.static", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyRefactoringBundle.message("intention.converting.to.static.family", new Object[0]);
    }

    private final boolean isCSAnnotated(PsiElement element) {
        if (!(element instanceof GrMember)) {
            return false;
        }
        PsiAnnotation psiAnnotation = GroovyPsiManager.getCompileStaticAnnotation((PsiMember)element);
        if (psiAnnotation == null) {
            return false;
        }
        PsiAnnotation annotation = psiAnnotation;
        return GroovyPsiManager.checkForPass(annotation);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Function1 function1 = (Function1)new Function1<PsiElement, Boolean>(this){

            public final boolean invoke(@NotNull PsiElement p1) {
                return ConvertToStaticIntention.access$isCSAnnotated((ConvertToStaticIntention)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ConvertToStaticIntention.class);
            }

            public final String getName() {
                return "isCSAnnotated";
            }

            public final String getSignature() {
                return "isCSAnnotated(Lcom/intellij/psi/PsiElement;)Z";
            }
        };
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, (Condition)new ConvertToStaticIntention$sam$com_intellij_openapi_util_Condition$0(function1));
        if (!(psiElement instanceof GrMember)) {
            psiElement = null;
        }
        GrMember grMember = (GrMember)psiElement;
        if (grMember == null) {
            return;
        }
        GrMember containingMember2 = grMember;
        ConvertToStatic.applyDeclarationFixes(containingMember2);
        ConvertToStatic.applyErrorFixes(containingMember2);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(this){
            final /* synthetic */ ConvertToStaticIntention this$0;

            public final boolean satisfiedBy(@NotNull PsiElement it) {
                if (!PsiUtil.isCompileStatic(it)) {
                    return false;
                }
                TypeChecker checker = new TypeChecker();
                it.accept((PsiElementVisitor)new GroovyPsiElementVisitor(checker));
                Collection collection = checker.getFixes();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return true;
                }
                return ConvertToStaticIntention.access$checkUnresolvedReferences(this.this$0, it);
            }
            {
                this.this$0 = convertToStaticIntention;
            }
        };
    }

    private final boolean checkUnresolvedReferences(PsiElement element) {
        PsiElement psiElement = element;
        if (!(psiElement instanceof GrReferenceExpression)) {
            psiElement = null;
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)psiElement;
        if (grReferenceExpression == null) {
            return false;
        }
        GrReferenceExpression expression = grReferenceExpression;
        if (expression.advancedResolve().isValidResult()) {
            return false;
        }
        GrExpression grExpression = expression.getQualifierExpression();
        if (grExpression == null) {
            return false;
        }
        GrExpression qualifier = grExpression;
        Collection collection = ConvertToStatic.collectReferencedEmptyDeclarations(qualifier, false);
        boolean bl = false;
        return !collection.isEmpty();
    }

    public static final /* synthetic */ boolean access$isCSAnnotated(ConvertToStaticIntention $this, PsiElement element) {
        return $this.isCSAnnotated(element);
    }

    public static final /* synthetic */ boolean access$checkUnresolvedReferences(ConvertToStaticIntention $this, PsiElement element) {
        return $this.checkUnresolvedReferences(element);
    }
}

