/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public abstract class GroovyRefactoringUtil {
    private static final Logger LOG = Logger.getInstance(GroovyRefactoringUtil.class);
    public static final Collection<String> KEYWORDS = ContainerUtil.map((Object[])TokenSets.KEYWORDS.getTypes(), (Function)StringUtil.createToStringFunction(IElementType.class));
    private static final String[] finalModifiers = new String[]{"final"};

    public static PsiElement[] getExpressionOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope) {
        ArrayList occurrences = new ArrayList();
        Comparator comparator2 = (element1, element2) -> {
            if (element1 != null && element1.equals(element2)) {
                return 0;
            }
            if (element1 instanceof GrParameter && element2 instanceof GrParameter) {
                String name1 = ((GrParameter)element1).getName();
                String name2 = ((GrParameter)element2).getName();
                return name1.compareTo(name2);
            }
            return 1;
        };
        if (scope instanceof GrLoopStatement) {
            PsiElement son = expr;
            while (son.getParent() != null && !(son.getParent() instanceof GrLoopStatement)) {
                son = son.getParent();
            }
            assert (scope.equals(son.getParent()));
            GroovyRefactoringUtil.collectOccurrences(expr, son, occurrences, comparator2, false);
        } else {
            GroovyRefactoringUtil.collectOccurrences(expr, scope, occurrences, comparator2, scope instanceof GrTypeDefinition || scope instanceof GroovyFileBase);
        }
        return PsiUtilCore.toPsiElementArray(occurrences);
    }

    private static void collectOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope, @NotNull ArrayList<? super PsiElement> acc, Comparator<? super PsiElement> comparator2, boolean goIntoInner) {
        if (scope.equals(expr)) {
            acc.add((PsiElement)expr);
            return;
        }
        for (PsiElement child : scope.getChildren()) {
            if (!goIntoInner && (child instanceof GrTypeDefinition || child instanceof GrMethod && scope instanceof GroovyFileBase)) continue;
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child, (PsiElement)expr, comparator2, (boolean)false)) {
                acc.add((PsiElement)child);
                continue;
            }
            GroovyRefactoringUtil.collectOccurrences(expr, child, acc, comparator2, goIntoInner);
        }
    }

    public static boolean isAppropriateContainerForIntroduceVariable(PsiElement tempContainer) {
        return tempContainer instanceof GrOpenBlock || tempContainer instanceof GrClosableBlock || tempContainer instanceof GroovyFileBase || tempContainer instanceof GrCaseSection || tempContainer instanceof GrLoopStatement || tempContainer instanceof GrIfStatement;
    }

    public static void sortOccurrences(PsiElement[] occurrences) {
        Arrays.sort(occurrences, (elem1, elem2) -> {
            int offset1 = elem1.getTextRange().getStartOffset();
            int offset2 = elem2.getTextRange().getStartOffset();
            return offset1 - offset2;
        });
    }

    public static void highlightOccurrences(Project project, @Nullable Editor editor, PsiElement[] elements) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        if (elements.length > 0) {
            highlightManager.addOccurrenceHighlights(editor, elements, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, highlighters);
        }
    }

    public static void highlightOccurrencesByRanges(Project project, Editor editor, TextRange[] ranges) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        for (TextRange range : ranges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, highlighters);
        }
    }

    public static void trimSpacesAndComments(Editor editor, PsiFile file, boolean trimComments) {
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        while (file.findElementAt(start) instanceof PsiWhiteSpace || file.findElementAt(start) instanceof PsiComment && trimComments || file.findElementAt(start) != null && GroovyTokenTypes.mNLS.equals(file.findElementAt(start).getNode().getElementType())) {
            ++start;
        }
        while (file.findElementAt(end - 1) instanceof PsiWhiteSpace || file.findElementAt(end - 1) instanceof PsiComment && trimComments || file.findElementAt(end - 1) != null && (GroovyTokenTypes.mNLS.equals(file.findElementAt(end - 1).getNode().getElementType()) || GroovyTokenTypes.mSEMI.equals(file.findElementAt(end - 1).getNode().getElementType()))) {
            --end;
        }
        editor.getSelectionModel().setSelection(start, end);
    }

    public static PsiElement @NotNull [] findStatementsInRange(PsiFile file, int startOffset, int endOffset, boolean strict) {
        if (!(file instanceof GroovyFileBase)) {
            return PsiElement.EMPTY_ARRAY;
        }
        GroovyLanguage language = GroovyLanguage.INSTANCE;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, (Language)language);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, (Language)language);
        if (element1 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent2 instanceof GrCodeBlock || parent2 instanceof GroovyFileBase || parent2 instanceof GrCaseSection)) {
            if (parent2 instanceof GrStatement) {
                parent2 = parent2.getParent();
                break;
            }
            if (parent2 == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement prev = parent2;
            if (!((parent2 = parent2.getParent()) instanceof GrCodeBlock) || !(prev instanceof LeafPsiElement)) continue;
            parent2 = parent2.getParent();
        }
        if (!parent2.equals(element1)) {
            while (!parent2.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset() && strict) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent2.equals(element2)) {
            while (!parent2.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && strict) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent2 instanceof GrCodeBlock && parent2.getParent() instanceof GrBlockStatement && element1 == ((GrCodeBlock)parent2).getLBrace() && element2 == ((GrCodeBlock)parent2).getRBrace()) {
            return new PsiElement[]{parent2.getParent()};
        }
        PsiElement[] children = PsiElement.EMPTY_ARRAY;
        PsiElement psiChild = parent2.getFirstChild();
        if (psiChild != null) {
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            while (psiChild != null) {
                result2.add(psiChild);
                psiChild = psiChild.getNextSibling();
            }
            children = PsiUtilCore.toPsiElementArray(result2);
        }
        ArrayList<PsiElement> possibleStatements = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child == element1) {
                flag = true;
            }
            if (flag) {
                possibleStatements.add(child);
            }
            if (child == element2) break;
        }
        for (PsiElement element : possibleStatements) {
            if (element instanceof GrStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment || TokenSets.SEPARATORS.contains(element.getNode().getElementType())) continue;
            return PsiElement.EMPTY_ARRAY;
        }
        return PsiUtilCore.toPsiElementArray(possibleStatements);
    }

    public static boolean isSuperOrThisCall(GrStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof GrConstructorInvocation)) {
            return false;
        }
        GrConstructorInvocation expr = (GrConstructorInvocation)statement;
        return testForSuper && expr.isSuperCall() || testForThis && expr.isThisCall();
    }

    public static boolean hasWrongBreakStatements(PsiElement element) {
        ArrayList vector = new ArrayList();
        GroovyRefactoringUtil.addBreakStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addBreakStatements(PsiElement element, ArrayList<? super GrBreakStatement> vector) {
        if (element instanceof GrBreakStatement) {
            vector.add((GrBreakStatement)element);
        } else if (!(element instanceof GrLoopStatement || element instanceof GrSwitchStatement || element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addBreakStatements(psiElement, vector);
            }
        }
    }

    public static boolean hasWrongContinueStatements(PsiElement element) {
        ArrayList vector = new ArrayList();
        GroovyRefactoringUtil.addContinueStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addContinueStatements(PsiElement element, ArrayList<? super GrContinueStatement> vector) {
        if (element instanceof GrContinueStatement) {
            vector.add((GrContinueStatement)element);
        } else if (!(element instanceof GrLoopStatement) && !(element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addContinueStatements(psiElement, vector);
            }
        }
    }

    public static String getMethodSignature(PsiMethod method) {
        PsiType[] types;
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        StringBuilder s = new StringBuilder(signature.getName() + "(");
        int i = 0;
        for (PsiType type2 : types = signature.getParameterTypes()) {
            s.append(type2.getPresentableText());
            if (i < types.length - 1) {
                s.append(", ");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    @Nullable
    public static GrCall getCallExpressionByMethodReference(@Nullable PsiElement ref) {
        if (ref == null) {
            return null;
        }
        if (ref instanceof GrEnumConstant) {
            return (GrEnumConstant)ref;
        }
        if (ref instanceof GrConstructorInvocation) {
            return (GrCall)ref;
        }
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof GrCall) {
            return (GrCall)parent2;
        }
        if (parent2 instanceof GrAnonymousClassDefinition) {
            return (GrCall)parent2.getParent();
        }
        return null;
    }

    public static boolean isMethodUsage(PsiElement ref) {
        return ref instanceof GrEnumConstant || ref.getParent() instanceof GrCall || ref instanceof GrConstructorInvocation;
    }

    public static String createTempVar(GrExpression expr, final GroovyPsiElement context, boolean declareFinal) {
        GrVariableDeclarationOwner block = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)(expr = GroovyRefactoringUtil.addBlockIntoParent(expr)), GrVariableDeclarationOwner.class);
        LOG.assertTrue(block != null);
        PsiElement anchorStatement = PsiTreeUtil.findPrevParent((PsiElement)block, (PsiElement)expr);
        LOG.assertTrue(anchorStatement instanceof GrStatement);
        Project project = expr.getProject();
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, new NameValidator(){

            @Override
            public String validateName(String name, boolean increaseNumber) {
                return name;
            }

            @Override
            public Project getProject() {
                return context.getProject();
            }
        });
        String prefix = suggestedNames[0];
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, (PsiElement)context, true);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
        String[] modifiers = declareFinal ? finalModifiers : ArrayUtilRt.EMPTY_STRING_ARRAY;
        GrVariableDeclaration decl = factory.createVariableDeclaration(modifiers, (GrExpression)PsiUtil.skipParentheses(expr, false), expr.getType(), id);
        GrStatement statement = ((GrStatementOwner)anchorStatement.getParent()).addStatementBefore(decl, (GrStatement)anchorStatement);
        JavaCodeStyleManager.getInstance((Project)statement.getProject()).shortenClassReferences((PsiElement)statement);
        return id;
    }

    public static int verifySafeCopyExpression(GrExpression expression) {
        return GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(expression);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result2 = 0;
        if (element == null) {
            return result2;
        }
        if (element instanceof GrNamedElement) {
            return 0;
        }
        if (element instanceof GrMethodCallExpression) {
            result2 = 1;
        }
        if (element instanceof GrNewExpression) {
            return 2;
        }
        if (element instanceof GrAssignmentExpression) {
            return 2;
        }
        if (element instanceof GrClosableBlock) {
            return 2;
        }
        if (PsiUtil.isPlusPlusOrMinusMinus(element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result2 = Math.max(result2, childResult);
        }
        return result2;
    }

    public static boolean isCorrectReferenceName(String newName, Project project) {
        if (newName.startsWith("'''") || newName.startsWith("\"\"\"") ? newName.length() < 6 || !newName.endsWith("'''") : !(!StringUtil.startsWithChar((CharSequence)newName, (char)'\'') && !StringUtil.startsWithChar((CharSequence)newName, (char)'\"') || newName.length() >= 2 && newName.endsWith("'"))) {
            return false;
        }
        if (KEYWORDS.contains(newName)) {
            return false;
        }
        try {
            GroovyPsiElementFactory.getInstance(project).createReferenceNameFromText(newName);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public static GrExpression generateArgFromMultiArg(PsiSubstitutor substitutor, List<? extends PsiElement> arguments2, @Nullable PsiType type2, Project project) {
        StringBuilder argText = new StringBuilder();
        argText.append("[");
        for (PsiElement psiElement : arguments2) {
            argText.append(psiElement.getText()).append(", ");
        }
        if (!arguments2.isEmpty()) {
            argText.delete(argText.length() - 2, argText.length());
        }
        argText.append("]");
        if (type2 instanceof PsiArrayType) {
            type2 = substitutor.substitute(type2);
            String typeText = type2.getCanonicalText();
            if (type2 instanceof PsiEllipsisType) {
                typeText = typeText.replace("...", "[]");
            }
            argText.append(" as ").append(typeText);
        }
        return GroovyPsiElementFactory.getInstance(project).createExpressionFromText(argText.toString());
    }

    public static boolean hasSideEffect(@NotNull GroovyPsiElement statement) {
        final Ref hasSideEffect = new Ref((Object)false);
        statement.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitCallExpression(@NotNull GrCallExpression callExpression) {
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitElement(@NotNull GroovyPsiElement element) {
                if (((Boolean)hasSideEffect.get()).booleanValue()) {
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)hasSideEffect.get();
    }

    @NotNull
    public static <Type extends PsiElement> Type addBlockIntoParent(@NotNull Type statement) throws IncorrectOperationException {
        PsiElement parent2 = statement.getParent();
        Object child = statement;
        while (!(parent2 instanceof GrLoopStatement || parent2 instanceof GrIfStatement || parent2 instanceof GrVariableDeclarationOwner || parent2 == null)) {
            parent2 = parent2.getParent();
            child = child.getParent();
        }
        if (parent2 instanceof GrWhileStatement && child == ((GrWhileStatement)parent2).getCondition() || parent2 instanceof GrIfStatement && child == ((GrIfStatement)parent2).getCondition()) {
            parent2 = parent2.getParent();
        }
        assert (parent2 != null);
        if (parent2 instanceof GrVariableDeclarationOwner) {
            return statement;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        Object tempStmt = statement;
        while (parent2 != tempStmt.getParent()) {
            tempStmt = tempStmt.getParent();
        }
        GrStatement toAdd = (GrStatement)tempStmt.copy();
        GrBlockStatement blockStatement = factory.createBlockStatement(new GrStatement[0]);
        if (parent2 instanceof GrLoopStatement) {
            ((GrLoopStatement)parent2).replaceBody(blockStatement);
        } else {
            GrIfStatement ifStatement = (GrIfStatement)parent2;
            if (tempStmt == ifStatement.getThenBranch()) {
                ifStatement.replaceThenBranch(blockStatement);
            } else if (tempStmt == ifStatement.getElseBranch()) {
                ifStatement.replaceElseBranch(blockStatement);
            }
        }
        GrStatement result2 = blockStatement.getBlock().addStatementBefore(toAdd, null);
        statement = result2 instanceof GrReturnStatement ? ((GrReturnStatement)result2).getReturnValue() : result2;
        return statement;
    }

    public static boolean isDiamondNewOperator(GrExpression expression) {
        PsiElement element = PsiUtil.skipParentheses(expression, false);
        if (!(element instanceof GrNewExpression)) {
            return false;
        }
        if (((GrNewExpression)element).getArrayCount() > 0) {
            return false;
        }
        GrCodeReferenceElement referenceElement = ((GrNewExpression)element).getReferenceElement();
        if (referenceElement == null) {
            return false;
        }
        GrTypeArgumentList typeArgumentList = referenceElement.getTypeArgumentList();
        return typeArgumentList != null && typeArgumentList.isDiamond();
    }

    @Nullable
    public static GrStatementOwner getDeclarationOwner(GrStatement statement) {
        PsiElement parent2 = statement.getParent();
        return parent2 instanceof GrStatementOwner ? (GrStatementOwner)parent2 : null;
    }

    @NotNull
    private static PsiType getType(@NotNull PsiParameter myParameter) {
        PsiType type2 = myParameter.getType();
        return type2 instanceof PsiEllipsisType ? ((PsiEllipsisType)type2).toArrayType() : type2;
    }

    @NotNull
    public static PsiType getSubstitutedType(@NotNull GrParameter parameter) {
        PsiType type2 = GroovyRefactoringUtil.getType(parameter);
        if (type2 instanceof PsiArrayType) {
            return type2;
        }
        PsiClassType.ClassResolveResult result2 = com.intellij.psi.util.PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return type2;
        }
        HashSet usedTypeParameters = new HashSet();
        GroovyRefactoringUtil.collectTypeParameters(usedTypeParameters, parameter);
        Iterator iterator2 = usedTypeParameters.iterator();
        while (iterator2.hasNext()) {
            PsiTypeParameter usedTypeParameter = (PsiTypeParameter)iterator2.next();
            if (parameter.getDeclarationScope() == usedTypeParameter.getOwner()) continue;
            iterator2.remove();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parameter.getProject());
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter usedTypeParameter : usedTypeParameters) {
            subst = subst.put(usedTypeParameter, TypeConversionUtil.typeParameterErasure((PsiTypeParameter)usedTypeParameter));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        Map typeMap = result2.getSubstitutor().getSubstitutionMap();
        Iterator iterator3 = typeMap.keySet().iterator();
        while (iterator3.hasNext()) {
            PsiTypeParameter typeParameter;
            PsiType psiType = (PsiType)typeMap.get(typeParameter = (PsiTypeParameter)iterator3.next());
            substitutor = substitutor.put(typeParameter, psiType != null ? subst.substitute(psiType) : null);
        }
        return psiClass instanceof PsiTypeParameter ? subst.substitute((PsiTypeParameter)psiClass) : elementFactory.createType(psiClass, substitutor);
    }

    public static void collectTypeParameters(final Set<? super PsiTypeParameter> used, final @NotNull GroovyPsiElement element) {
        element.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement reference) {
                PsiTypeParameter typeParameter;
                PsiElement resolved;
                super.visitCodeReferenceElement(reference);
                if (reference.getQualifier() == null && (resolved = reference.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)(typeParameter = (PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)false)) {
                    used.add(typeParameter);
                }
            }

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                super.visitExpression(expression);
                PsiType type2 = expression.getType();
                if (type2 != null) {
                    TypeParameterSearcher searcher = new TypeParameterSearcher();
                    type2.accept((PsiTypeVisitor)searcher);
                    for (PsiTypeParameter typeParam : searcher.myTypeParams) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)typeParam.getOwner(), (PsiElement)element, (boolean)false)) continue;
                        used.add(typeParam);
                    }
                }
            }

            class TypeParameterSearcher
            extends PsiTypeVisitor<Boolean> {
                private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

                TypeParameterSearcher() {
                }

                public Boolean visitType(@NotNull PsiType type2) {
                    return false;
                }

                public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                    return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                }

                public Boolean visitClassType(@NotNull PsiClassType classType) {
                    PsiType[] types;
                    PsiClass aClass = classType.resolve();
                    if (aClass instanceof PsiTypeParameter) {
                        this.myTypeParams.add((PsiTypeParameter)aClass);
                    }
                    for (PsiType psiType : types = classType.getParameters()) {
                        psiType.accept((PsiTypeVisitor)this);
                    }
                    return false;
                }

                public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        bound.accept((PsiTypeVisitor)this);
                    }
                    return false;
                }
            }
        });
    }

    @NotNull
    public static String getNewName(@NotNull PsiNamedElement element, boolean property) {
        String name = element instanceof PsiMethod && property ? GroovyPropertyUtils.getPropertyName((PsiMethod)element) : element.getName();
        LOG.assertTrue(name != null, (Object)element);
        return name;
    }
}

