/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.overrideImplement;

import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.util.GroovyOverrideImplementUtil;

public class GroovyMethodImplementor
implements MethodImplementor {
    public PsiMethod @NotNull [] getMethodsToImplement(PsiClass aClass) {
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiMethod @NotNull [] createImplementationPrototypes(PsiClass inClass, PsiMethod method) throws IncorrectOperationException {
        if (!(inClass instanceof GrTypeDefinition)) {
            return PsiMethod.EMPTY_ARRAY;
        }
        if (method instanceof GrTraitMethod) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiSubstitutor substitutor = inClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)inClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        return new PsiMethod[]{GroovyOverrideImplementUtil.generateMethodPrototype((GrTypeDefinition)inClass, method, substitutor)};
    }

    public GenerationInfo createGenerationInfo(PsiMethod method, boolean mergeIfExists) {
        if (method instanceof GrMethod) {
            return new GroovyGenerationInfo<GrMethod>((GrMethod)method, mergeIfExists);
        }
        return null;
    }

    @NotNull
    public Consumer<PsiMethod> createDecorator(PsiClass targetClass, PsiMethod baseMethod, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) {
        return new PsiMethodConsumer(targetClass, toCopyJavaDoc, baseMethod, insertOverrideIfPossible);
    }

    static class PsiMethodConsumer
    implements Consumer<PsiMethod> {
        private final PsiClass myTargetClass;
        private final boolean myToCopyJavaDoc;
        private final PsiMethod myBaseMethod;
        private final boolean myInsertOverrideIfPossible;

        PsiMethodConsumer(PsiClass targetClass, boolean toCopyJavaDoc, PsiMethod baseMethod, boolean insertOverrideIfPossible) {
            this.myTargetClass = targetClass;
            this.myToCopyJavaDoc = toCopyJavaDoc;
            this.myBaseMethod = baseMethod;
            this.myInsertOverrideIfPossible = insertOverrideIfPossible;
        }

        public void consume(PsiMethod method) {
            Project project = this.myTargetClass.getProject();
            if (this.myToCopyJavaDoc) {
                PsiDocComment baseMethodDocComment = this.myBaseMethod.getDocComment();
                if (baseMethodDocComment != null) {
                    GrDocComment docComment = GroovyPsiElementFactory.getInstance(project).createDocCommentFromText(baseMethodDocComment.getText());
                    GrDocCommentUtil.setDocComment((GrMethod)method, docComment);
                }
            } else {
                PsiDocComment docComment = method.getDocComment();
                if (docComment != null) {
                    docComment.delete();
                }
            }
            if (this.myInsertOverrideIfPossible) {
                if (OverrideImplementUtil.canInsertOverride((PsiMethod)method, (PsiClass)this.myTargetClass) && JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Override", this.myTargetClass.getResolveScope()) != null && !method.getModifierList().hasAnnotation("java.lang.Override")) {
                    method.getModifierList().addAnnotation("java.lang.Override");
                }
            } else {
                PsiAnnotation annotation = method.getModifierList().findAnnotation("java.lang.Override");
                if (annotation != null) {
                    annotation.delete();
                }
            }
        }
    }
}

