/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvcCommand {
    public static final Collection<String> ourEnvironments = ContainerUtil.immutableList((Object[])new String[]{"prod", "test", "dev"});
    private final Map<String, String> myEnvVariables = new HashMap<String, String>();
    private boolean myPassParentEnvs = true;
    @Nullable
    private String myEnv;
    @Nullable
    private String myCommand;
    @Nullable
    private String myVmOptions;
    private final ArrayList<String> myArgs = new ArrayList();
    private final ArrayList<String> myProperties = new ArrayList();

    public MvcCommand() {
    }

    public MvcCommand(@Nullable String command, String ... args) {
        this.myCommand = command;
        Collections.addAll(this.myArgs, args);
    }

    @Nullable
    public String getEnv() {
        return this.myEnv;
    }

    public void setEnv(@Nullable String env) {
        this.myEnv = env;
    }

    @Nullable
    public String getCommand() {
        return this.myCommand;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public MvcCommand setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        return this.myEnvVariables;
    }

    public MvcCommand setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (this.myEnvVariables != envVariables) {
            this.myEnvVariables.clear();
            this.myEnvVariables.putAll(envVariables);
        }
        return this;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public MvcCommand setPassParentEnvs(boolean passParentEnv) {
        this.myPassParentEnvs = passParentEnv;
        return this;
    }

    public ArrayList<String> getArgs() {
        return this.myArgs;
    }

    public void setArgs(@NotNull List<String> args) {
        if (args == this.myArgs) {
            return;
        }
        this.myArgs.clear();
        this.myArgs.addAll(args);
    }

    public ArrayList<String> getProperties() {
        return this.myProperties;
    }

    public void setProperties(@NotNull List<String> properties) {
        if (this.myProperties == properties) {
            return;
        }
        this.myProperties.clear();
        this.myProperties.addAll(properties);
    }

    public void addToParametersList(@NotNull ParametersList list) {
        if (this.myEnv != null) {
            list.add(this.myEnv);
        }
        list.addAll(this.myProperties);
        if (this.myCommand != null) {
            list.add(this.myCommand);
        }
        list.addAll(this.myArgs);
    }

    @NotNull
    public static MvcCommand parse(@NotNull String cmd) {
        int i;
        String[] args = ParametersList.parse((String)cmd);
        MvcCommand res = new MvcCommand();
        for (i = 0; res.myCommand == null && i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("-D")) {
                res.myProperties.add(s);
                continue;
            }
            if (res.myEnv == null && ourEnvironments.contains(s)) {
                res.myEnv = s;
                continue;
            }
            res.myCommand = s;
        }
        res.myArgs.addAll(Arrays.asList(args).subList(i, args.length));
        return res;
    }
}

