/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;

class CurriedSignature
implements CallSignature<CallParameter> {
    private final CallSignature<?> myOriginal;
    private final int myPosition;
    private final List<? extends Argument> myArguments;

    CurriedSignature(@NotNull CallSignature<?> original, int position, @NotNull List<? extends Argument> arguments2) {
        this.myOriginal = original;
        this.myPosition = position;
        this.myArguments = arguments2;
    }

    @Override
    public boolean isVararg() {
        return this.myOriginal.isVararg();
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myOriginal.getReturnType();
    }

    @Override
    public int getParameterCount() {
        return this.myOriginal.getParameterCount() - this.myArguments.size();
    }

    @Override
    @NotNull
    public List<CallParameter> getParameters() {
        int argumentCount = this.myArguments.size();
        List<?> originalParameters = this.myOriginal.getParameters();
        int originalParameterCount = originalParameters.size();
        if (this.isVararg()) {
            CallParameter varargParameter = (CallParameter)ContainerUtil.getLastItem(originalParameters);
            List<?> nonVarargParameters = originalParameters.subList(0, originalParameterCount - 1);
            return ContainerUtil.concat((List[])new List[]{nonVarargParameters.subList(0, this.myPosition), nonVarargParameters.subList(this.myPosition + argumentCount, nonVarargParameters.size() - 1), Collections.singletonList(varargParameter)});
        }
        return ContainerUtil.concat(originalParameters.subList(0, this.myPosition), originalParameters.subList(this.myPosition + argumentCount, originalParameterCount));
    }

    @Override
    @Nullable
    public ArgumentMapping<? extends CallParameter> applyTo(@NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        int position;
        int argumentCount = arguments2.size();
        int n = this.myPosition < 0 ? (this.isVararg() ? this.myPosition + argumentCount + this.myArguments.size() : this.myPosition + this.getParameterCount()) : (position = this.myPosition);
        if (position < 0 || argumentCount < position) {
            return null;
        }
        List uncurriedArguments = ContainerUtil.concat((List[])new List[]{arguments2.subList(0, position), this.myArguments, arguments2.subList(position, argumentCount)});
        return this.myOriginal.applyTo(uncurriedArguments, context);
    }
}

