/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public abstract class BuilderAnnotationContributor
implements AstTransformationSupport {
    public static final String BUILDER_PACKAGE = "groovy.transform.builder";
    public static final String BUILDER_FQN = "groovy.transform.builder.Builder";
    public static final String ORIGIN_INFO = "via @Builder";
    public static final String STRATEGY_ATTRIBUTE = "builderStrategy";

    @Contract(value="null, _ -> false")
    public static boolean isApplicable(@Nullable PsiAnnotation annotation, @NotNull String strategy) {
        if (annotation == null) {
            return false;
        }
        PsiClass aClass = GrAnnotationUtil.inferClassAttribute(annotation, STRATEGY_ATTRIBUTE);
        if (aClass == null) {
            return false;
        }
        return StringUtil.getQualifiedName((String)BUILDER_PACKAGE, (String)strategy).equals(aClass.getQualifiedName());
    }

    public static PsiField[] getFields(@NotNull TransformationContext context, boolean includeSuper) {
        return BuilderAnnotationContributor.filterFields(includeSuper ? context.getAllFields(false) : context.getFields());
    }

    public static PsiField[] getFields(@NotNull GrTypeDefinition clazz, boolean includeSuper) {
        return BuilderAnnotationContributor.filterFields(includeSuper ? Arrays.asList(GrClassImplUtil.getAllFields(clazz, false)) : Arrays.asList(clazz.getFields()));
    }

    private static PsiField[] filterFields(Collection<? extends PsiField> collectedFields) {
        return (PsiField[])collectedFields.stream().filter(field -> !field.hasModifierProperty("static")).filter(field -> {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null || aClass.getQualifiedName() == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            return !name.equals("groovy.lang.GroovyObjectSupport") && !name.equals("groovy.lang.GroovyObject");
        }).toArray(PsiField[]::new);
    }

    public static boolean isIncludeSuperProperties(@NotNull PsiAnnotation annotation) {
        return PsiUtil.getAnnoAttributeValue(annotation, "includeSuperProperties", false);
    }
}

