/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.GroovyMapPropertyImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\f\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u000f\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"doProcessReceiverType", "", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "doProcessReceiverType0", "processClassType", "Lcom/intellij/psi/PsiClassType;", "processMapType", "processReceiver", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "processReceiverType", "intellij.groovy.psi"})
public final class ReceiverKt {
    public static final boolean processReceiver(@NotNull Argument $this$processReceiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        PsiType psiType = $this$processReceiver.getTopLevelType();
        if (psiType == null) {
            psiType = (PsiType)TypesUtil.getJavaLangObject(place);
        }
        if (psiType == null) {
            return true;
        }
        PsiType receiverType = psiType;
        return ReceiverKt.doProcessReceiverType0(receiverType, processor, state.put(ClassHint.RECEIVER, (Object)$this$processReceiver), place);
    }

    public static final boolean processReceiverType(@Nullable PsiType $this$processReceiverType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if ($this$processReceiverType == null) {
            return true;
        }
        return ReceiverKt.doProcessReceiverType0($this$processReceiverType, processor, state.put(ClassHint.RECEIVER, (Object)new JustTypeArgument($this$processReceiverType)), place);
    }

    private static final boolean doProcessReceiverType0(PsiType $this$doProcessReceiverType0, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!ReceiverKt.doProcessReceiverType($this$doProcessReceiverType0, processor, state, place)) {
            return false;
        }
        return !ResolveUtilKt.processNonCodeMembers(state) || ResolveUtil.processNonCodeMembers($this$doProcessReceiverType0, processor, place, state);
    }

    private static final boolean doProcessReceiverType(PsiType $this$doProcessReceiverType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        boolean bl;
        block21: {
            PsiType psiType = $this$doProcessReceiverType;
            if (psiType instanceof PsiPrimitiveType) {
                PsiClassType psiClassType = ((PsiPrimitiveType)$this$doProcessReceiverType).getBoxedType(place);
                bl = psiClassType != null ? ReceiverKt.processReceiverType((PsiType)psiClassType, processor, state, place) : true;
            } else if (psiType instanceof PsiDisjunctionType) {
                bl = ReceiverKt.processReceiverType(((PsiDisjunctionType)$this$doProcessReceiverType).getLeastUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiIntersectionType) {
                PsiType[] $this$all$iv = ((PsiIntersectionType)$this$doProcessReceiverType).getConjuncts();
                boolean $i$f$all = false;
                PsiType[] psiTypeArray = $this$all$iv;
                int n = psiTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiType element$iv;
                    PsiType it = element$iv = psiTypeArray[i];
                    boolean bl2 = false;
                    if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            } else if (psiType instanceof PsiCapturedWildcardType) {
                bl = ReceiverKt.processReceiverType(((PsiCapturedWildcardType)$this$doProcessReceiverType).getUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiWildcardType) {
                bl = !((PsiWildcardType)$this$doProcessReceiverType).isExtends() || ReceiverKt.processReceiverType(((PsiWildcardType)$this$doProcessReceiverType).getExtendsBound(), processor, state, place);
            } else if (psiType instanceof GrTraitType) {
                Iterable $this$all$iv = ArraysKt.reversed((Object[])((GrTraitType)$this$doProcessReceiverType).getConjuncts());
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiType it = (PsiType)element$iv;
                        boolean bl3 = false;
                        if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            } else if (psiType instanceof PsiArrayType) {
                GrTypeDefinition grTypeDefinition = GroovyPsiManager.getInstance(place.getProject()).getArrayClass(((PsiArrayType)$this$doProcessReceiverType).getComponentType());
                if (grTypeDefinition == null) {
                    return true;
                }
                GrTypeDefinition arrayClass = grTypeDefinition;
                bl = ResolveUtil.processClassDeclarations(arrayClass, processor, state, null, place);
            } else if (psiType instanceof PsiClassType) {
                bl = ReceiverKt.processClassType((PsiClassType)$this$doProcessReceiverType, processor, state, place);
            } else {
                return true;
            }
        }
        return bl;
    }

    private static final boolean processClassType(PsiClassType $this$processClassType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiClassType.ClassResolveResult result2 = $this$processClassType.resolveGenerics();
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        ResolveState newState = state.put(PsiSubstitutor.KEY, (Object)((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).putAll(result2.getSubstitutor()));
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true) ^ true && Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"java.lang.Class")) {
            PsiClassType type2;
            Object object = ArraysKt.singleOrNull((Object[])$this$processClassType.getParameters());
            if (!(object instanceof PsiClassType)) {
                object = null;
            }
            if (!ReceiverKt.processReceiverType((PsiType)(type2 = (PsiClassType)object), processor, newState.put(ClassHint.STATIC_CONTEXT, (Object)true), place)) {
                return false;
            }
        }
        if (!ReceiverKt.processMapType($this$processClassType, processor, newState, place)) {
            return false;
        }
        return ResolveUtil.processClassDeclarations(clazz, processor, newState, null, place);
    }

    private static final boolean processMapType(PsiClassType $this$processMapType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        GroovyMapPropertyImpl property;
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessProperties(processor)) {
            return true;
        }
        if (!($this$processMapType instanceof GrMapType) && !InheritanceUtil.isInheritor((PsiType)((PsiType)$this$processMapType), (String)"java.util.Map")) {
            return true;
        }
        String name = ResolveUtilKt.getName(processor, state);
        if (name != null && !processor.execute((PsiElement)(property = new GroovyMapPropertyImpl($this$processMapType, name, place)), state)) {
            return false;
        }
        return ResolveUtilKt.shouldProcessMethods(processor);
    }
}

