/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GrImportUtil {
    public static boolean acceptName(GrReferenceElement ref, String expected) {
        String actual = ref.getReferenceName();
        if (expected.equals(actual)) {
            return true;
        }
        if (ref.getQualifier() != null) {
            return false;
        }
        PsiFile file = ref.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        MultiMap<String, String> data = GrImportUtil.getAliases((GroovyFile)file);
        Collection aliases = data.get((Object)expected);
        return aliases.contains(actual);
    }

    @NotNull
    private static MultiMap<String, String> getAliases(GroovyFile file) {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(GrImportUtil.collectAliases(file), (Object[])new Object[]{file}));
    }

    @NotNull
    private static MultiMap<String, String> collectAliases(@NotNull GroovyFile file) {
        MultiMap aliases = MultiMap.createSet();
        for (GrImportStatement anImport : file.getImportStatements()) {
            String refName;
            GrCodeReferenceElement importReference;
            if (!anImport.isAliasedImport() || (importReference = anImport.getImportReference()) == null || (refName = importReference.getReferenceName()) == null) continue;
            aliases.putValue((Object)refName, (Object)anImport.getImportedName());
        }
        return aliases;
    }
}

