/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class MapEntryOrKeyValueHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.MapEntryOrKeyValue";
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, String @NotNull [] options2) {
        PsiType[] psiTypeArray;
        PsiType[] psiTypeArray2;
        int argNum = MapEntryOrKeyValueHintProcessor.extractArgNum(options2);
        boolean index = MapEntryOrKeyValueHintProcessor.extractIndex(options2);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (argNum >= parameters2.length) {
            return ContainerUtil.emptyList();
        }
        PsiParameter parameter = parameters2[argNum];
        PsiType type2 = parameter.getType();
        PsiType substituted = substitutor.substitute(type2);
        if (!InheritanceUtil.isInheritor((PsiType)substituted, (String)"java.util.Map")) {
            return ContainerUtil.emptyList();
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)1, (boolean)true);
        PsiClass mapEntry = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Map.Entry", method.getResolveScope());
        if (mapEntry == null) {
            return ContainerUtil.emptyList();
        }
        PsiClassType mapEntryType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(mapEntry, new PsiType[]{key, value});
        if (index) {
            PsiType[] psiTypeArray3 = new PsiType[3];
            psiTypeArray3[0] = key;
            psiTypeArray3[1] = value;
            psiTypeArray2 = psiTypeArray3;
            psiTypeArray3[2] = PsiType.INT;
        } else {
            PsiType[] psiTypeArray4 = new PsiType[2];
            psiTypeArray4[0] = key;
            psiTypeArray2 = psiTypeArray4;
            psiTypeArray4[1] = value;
        }
        PsiType[] keyValueSignature = psiTypeArray2;
        if (index) {
            PsiType[] psiTypeArray5 = new PsiType[2];
            psiTypeArray5[0] = mapEntryType;
            psiTypeArray = psiTypeArray5;
            psiTypeArray5[1] = PsiType.INT;
        } else {
            PsiType[] psiTypeArray6 = new PsiType[1];
            psiTypeArray = psiTypeArray6;
            psiTypeArray6[0] = mapEntryType;
        }
        PsiType[] mapEntrySignature = psiTypeArray;
        return ContainerUtil.newArrayList((Object[])new PsiType[][]{keyValueSignature, mapEntrySignature});
    }

    private static int extractArgNum(String[] options2) {
        for (String value : options2) {
            Integer parsedValue = MapEntryOrKeyValueHintProcessor.parseArgNum(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options2.length == 1) {
            return StringUtil.parseInt((String)options2[0], (int)0);
        }
        return 0;
    }

    private static boolean extractIndex(String[] options2) {
        for (String value : options2) {
            Boolean parsedValue = MapEntryOrKeyValueHintProcessor.parseIndex(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options2.length == 1) {
            return Boolean.parseBoolean(options2[0]);
        }
        return false;
    }

    private static Boolean parseIndex(String value) {
        Couple<String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        if ("index".equals(pair.getFirst())) {
            return Boolean.valueOf((String)pair.getSecond());
        }
        return null;
    }

    private static Integer parseArgNum(String value) {
        Couple<String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        if ("argNum".equals(pair.getFirst())) {
            return StringUtil.parseInt((String)((String)pair.getSecond()), (int)0);
        }
        return null;
    }

    @Nullable
    private static Couple<String> parseValue(String value) {
        String[] split = value.split("=");
        return split.length == 2 ? Couple.of((Object)split[0].trim(), (Object)split[1].trim()) : null;
    }
}

