/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrEnumConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return position == GrTypeConverter.Position.ASSIGNMENT || position == GrTypeConverter.Position.RETURN_VALUE;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (!TypesUtil.isEnum(targetType)) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiType)actualType, (String)"groovy.lang.GString") || InheritanceUtil.isInheritor((PsiType)actualType, (String)"java.lang.String")) {
            return GroovyConfigUtils.getInstance().isVersionAtLeast(context, "1.8") ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return null;
    }
}

