/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GrLightVariable
extends GrImplicitVariableImpl
implements NavigatablePsiElement {
    private final List<PsiElement> myDeclarations;
    private Object myCreatorKey;

    public GrLightVariable(PsiManager manager, @NonNls String name, @NonNls @NotNull String type2, @NotNull PsiElement navigationElement) {
        this(manager, name, type2, Collections.singletonList(navigationElement), GrLightVariable.getDeclarationScope(navigationElement));
    }

    public GrLightVariable(PsiManager manager, @NonNls String name, @NonNls @NotNull String type2, @NotNull List<PsiElement> declarations, @NotNull PsiElement scope) {
        this(manager, name, JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeFromText(type2, scope), declarations, scope);
    }

    public GrLightVariable(PsiManager manager, @NonNls String name, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
        this(manager, name, type2, Collections.singletonList(navigationElement), GrLightVariable.getDeclarationScope(navigationElement));
    }

    public GrLightVariable(PsiManager manager, @NonNls String name, @NotNull PsiType type2, @NotNull List<PsiElement> declarations, @NotNull PsiElement scope) {
        super(manager, (PsiIdentifier)new GrImplicitVariableImpl.GrLightIdentifier(manager, name), type2, false, scope);
        this.myDeclarations = declarations;
        if (!this.myDeclarations.isEmpty()) {
            this.setNavigationElement(this.myDeclarations.get(0));
        }
    }

    private static PsiElement getDeclarationScope(PsiElement navigationElement) {
        return navigationElement.getContainingFile();
    }

    public boolean isWritable() {
        return this.getNavigationElement() != this;
    }

    public PsiFile getContainingFile() {
        if (!this.myDeclarations.isEmpty()) {
            return this.myDeclarations.get(0).getContainingFile();
        }
        return this.getDeclarationScope().getContainingFile();
    }

    public boolean isValid() {
        for (PsiElement declaration : this.myDeclarations) {
            if (declaration.isValid()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope(this.getDeclarationScope());
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this.myDeclarations.contains(another) || super.isEquivalentTo(another);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        for (PsiElement declaration : this.myDeclarations) {
            if (declaration instanceof PsiNamedElement) {
                if (declaration instanceof PsiMethod) {
                    name = GroovyPropertyUtils.getGetterNameNonBoolean(name);
                }
                ((PsiNamedElement)declaration).setName(name);
                continue;
            }
            if (declaration instanceof GrArgumentLabel) {
                ((GrArgumentLabel)declaration).setName(name);
                continue;
            }
            if (declaration instanceof XmlAttributeValue) {
                PsiElement rightQuote;
                PsiElement textToken;
                PsiElement leftQuote = declaration.getFirstChild();
                if (!(leftQuote instanceof XmlToken) || !((textToken = leftQuote.getNextSibling()) instanceof XmlToken) || !((rightQuote = textToken.getNextSibling()) instanceof XmlToken) || rightQuote.getNextSibling() != null) continue;
                ((LeafElement)textToken).replaceWithText(name);
                continue;
            }
            if (!(declaration instanceof GrReferenceExpression)) continue;
            ((GrReferenceExpression)declaration).handleElementRename(name);
        }
        return this.getNameIdentifier().replace((PsiElement)new GrImplicitVariableImpl.GrLightIdentifier(this.myManager, name));
    }

    public Object getCreatorKey() {
        return this.myCreatorKey;
    }

    public void setCreatorKey(Object creatorKey) {
        this.myCreatorKey = creatorKey;
    }

    public List<PsiElement> getDeclarations() {
        return this.myDeclarations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrLightVariable variable = (GrLightVariable)o;
        return Objects.equals(this.getName(), variable.getName()) && Objects.equals(this.myDeclarations, variable.myDeclarations) && Objects.equals(this.myCreatorKey, variable.myCreatorKey);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.myDeclarations, this.myCreatorKey);
    }
}

