/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrPsiTypeStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

public class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance(GroovyPsiManager.class);
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass = new HashMap<String, GrTypeDefinition>();
    private final ConcurrentMap<GroovyPsiElement, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<GrExpression, PsiType> topLevelTypes = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<PsiMember, Boolean> myCompileStatic = ContainerUtil.createConcurrentWeakMap();
    private static final RecursionGuard<PsiElement> ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");
    private static final PsiType UNKNOWN_TYPE = new GrPsiTypeStub();

    public GroovyPsiManager(Project project) {
        this.myProject = project;
        PsiManagerEx.getInstanceEx((Project)this.myProject).registerRunnableToRunOnAnyChange(() -> this.dropTypesCache());
    }

    public void dropTypesCache() {
        this.myCalculatedTypes.clear();
        this.topLevelTypes.clear();
        this.myCompileStatic.clear();
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)ServiceManager.getService((Project)project, GroovyPsiManager.class);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        PsiClass result2;
        if (ourPopularClasses.contains(fqName) && (result2 = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result2);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
    }

    public boolean isCompileStatic(@NotNull PsiMember member) {
        return this.myCompileStatic.computeIfAbsent(member, this::isCompileStaticInner);
    }

    private boolean isCompileStaticInner(@NotNull PsiMember member) {
        PsiAnnotation annotation = GroovyPsiManager.getCompileStaticAnnotation(member);
        if (annotation != null) {
            return GroovyPsiManager.checkForPass(annotation);
        }
        PsiMember enclosingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class, (boolean)true);
        return enclosingMember != null && this.isCompileStatic(enclosingMember);
    }

    @Nullable
    public static PsiAnnotation getCompileStaticAnnotation(@NotNull PsiMember member) {
        PsiModifierList list = member.getModifierList();
        if (list == null) {
            return null;
        }
        PsiAnnotation compileStatic = list.findAnnotation("groovy.transform.CompileStatic");
        if (compileStatic != null) {
            return compileStatic;
        }
        return list.findAnnotation("groovy.transform.TypeChecked");
    }

    public static boolean checkForPass(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
        return value == null || value instanceof PsiReference && ResolveUtil.isEnumConstant((PsiReference)value, "PASS", "groovy.transform.TypeCheckingMode");
    }

    @Deprecated
    @Nullable
    public PsiClass findClassWithCache(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope);
    }

    @Nullable
    public <T extends GroovyPsiElement> PsiType getType(@NotNull T element, @NotNull Function<? super T, ? extends PsiType> calculator) {
        return GroovyPsiManager.getTypeWithCaching(element, this.myCalculatedTypes, calculator);
    }

    @Nullable
    public PsiType getTopLevelType(@NotNull GrExpression expression) {
        return GroovyPsiManager.getTypeWithCaching(expression, this.topLevelTypes, InferenceKt::getTopLevelType);
    }

    @Nullable
    private static <K extends GroovyPsiElement> PsiType getTypeWithCaching(@NotNull K key, @NotNull ConcurrentMap<? super K, PsiType> map2, @NotNull Function<? super K, ? extends PsiType> calculator) {
        PsiType type2 = (PsiType)map2.get(key);
        if (type2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            type2 = calculator.apply(key);
            if (type2 == null) {
                type2 = UNKNOWN_TYPE;
            }
            if (stamp.mayCacheNow()) {
                type2 = (PsiType)ConcurrencyUtil.cacheOrGet(map2, key, (Object)type2);
            } else {
                PsiType alreadyInferred = (PsiType)map2.get(key);
                if (alreadyInferred != null) {
                    type2 = alreadyInferred;
                }
            }
        }
        if (!type2.isValid()) {
            GroovyPsiManager.error(key, type2);
        }
        return UNKNOWN_TYPE == type2 ? null : type2;
    }

    private static void error(PsiElement element, PsiType type2) {
        LOG.error("Type is invalid: " + type2 + "; element: " + element + " of class " + element.getClass());
    }

    @Nullable
    public GrTypeDefinition getArrayClass(@NotNull PsiType type2) {
        String typeText = type2.getCanonicalText();
        GrTypeDefinition definition = this.myArrayClass.get(typeText);
        if (definition == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    @Nullable
    public static PsiType inferType(@NotNull PsiElement element, @NotNull Computable<? extends PsiType> computable) {
        List stack = ourGuard.currentStack();
        if (stack.size() > 7) {
            ourGuard.prohibitResultCaching(stack.get(0));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }
}

