/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrTraitType
extends PsiType {
    @NotNull
    private final PsiIntersectionType myDelegate;
    @NotNull
    private final PsiType myExprType;
    @NotNull
    private final List<PsiType> myTraitTypes;

    private GrTraitType(@NotNull PsiIntersectionType delegate) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myDelegate = delegate;
        this.myExprType = delegate.getConjuncts()[0];
        this.myTraitTypes = ContainerUtil.newArrayList((Object[])delegate.getConjuncts(), (int)1, (int)delegate.getConjuncts().length);
    }

    @NotNull
    public PsiType getExprType() {
        return this.myExprType;
    }

    @NotNull
    public List<PsiType> getTraitTypes() {
        return this.myTraitTypes;
    }

    public PsiType @NotNull [] getConjuncts() {
        return this.myDelegate.getConjuncts();
    }

    @NotNull
    public String getPresentableText() {
        return this.myExprType.getPresentableText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type2 -> type2.getPresentableText()), (String)", ");
    }

    @NotNull
    public String getCanonicalText() {
        return this.myDelegate.getCanonicalText();
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.myExprType.getCanonicalText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type2 -> type2.getInternalCanonicalText()), (String)", ");
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        return this.myDelegate.equalsToText(text);
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        return (A)this.myDelegate.accept(visitor2);
    }

    @Nullable
    public GlobalSearchScope getResolveScope() {
        return this.myDelegate.getResolveScope();
    }

    public PsiType @NotNull [] getSuperTypes() {
        return this.myDelegate.getSuperTypes();
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType type2, @NotNull List<? extends PsiType> traits) {
        return GrTraitType.createTraitType(ContainerUtil.prepend(traits, (Object[])new PsiType[]{type2 instanceof GrTraitType ? ((GrTraitType)type2).myDelegate : type2}));
    }

    @NotNull
    public static PsiType createTraitType(@NotNull List<PsiType> types) {
        return GrTraitType.createTraitType(types.toArray(PsiType.createArray((int)types.size())));
    }

    @NotNull
    public static PsiType createTraitType(PsiType @NotNull [] types) {
        Set flattened = PsiIntersectionType.flatten((PsiType[])types, (Set)new LinkedHashSet<PsiType>(){

            @Override
            public boolean add(PsiType type2) {
                this.remove(type2);
                return super.add(type2);
            }
        });
        PsiType[] conjuncts = flattened.toArray(PsiType.createArray((int)flattened.size()));
        if (conjuncts.length == 1) {
            return conjuncts[0];
        }
        return new GrTraitType((PsiIntersectionType)PsiIntersectionType.createIntersection((boolean)false, (PsiType[])conjuncts));
    }
}

