/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;

public final class GrClassReferenceType
extends PsiClassType {
    @NotNull
    private final GrCodeReferenceElement myReferenceElement;

    public GrClassReferenceType(@NotNull GrCodeReferenceElement referenceElement) {
        this(referenceElement, LanguageLevel.JDK_1_5);
    }

    private GrClassReferenceType(@NotNull GrCodeReferenceElement referenceElement, @NotNull LanguageLevel languageLevel) {
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    @Nullable
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Nullable
    public String getClassName() {
        PsiClass resolved = this.resolve();
        if (resolved != null) {
            return resolved.getName();
        }
        return this.myReferenceElement.getReferenceName();
    }

    public int getParameterCount() {
        GrTypeArgumentList typeArgumentList = this.myReferenceElement.getTypeArgumentList();
        return typeArgumentList == null ? 0 : typeArgumentList.getTypeArgumentCount();
    }

    public PsiType @NotNull [] getParameters() {
        return this.myReferenceElement.getTypeArguments();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        final GroovyResolveResult resolveResult2 = this.myReferenceElement.advancedResolve();
        return new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                PsiElement resolved = resolveResult2.getElement();
                return resolved instanceof PsiClass ? (PsiClass)resolved : null;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                return resolveResult2.getSubstitutor();
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return resolveResult2.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return resolveResult2.isStaticsOK();
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return resolveResult2.getCurrentFileResolveContext();
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
    }

    @NotNull
    public PsiClassType rawType() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myReferenceElement.getProject());
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            return factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz), this.getLanguageLevel());
        }
        String qName = StringUtil.notNullize((String)this.myReferenceElement.getQualifiedReferenceName());
        return factory.createTypeByFQClassName(qName, this.myReferenceElement.getResolveScope());
    }

    @NotNull
    public String getPresentableText() {
        return PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiAnnotation[])PsiAnnotation.EMPTY_ARRAY, (PsiType[])this.myReferenceElement.getTypeArguments());
    }

    @NotNull
    public String getCanonicalText() {
        return this.myReferenceElement.getCanonicalText();
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myReferenceElement.getResolveScope();
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrClassReferenceType(this.myReferenceElement, languageLevel);
    }

    @NotNull
    public GrCodeReferenceElement getReference() {
        return this.myReferenceElement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GrClassReferenceType && this.myReferenceElement.equals(((GrClassReferenceType)((Object)obj)).myReferenceElement)) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        String name = this.myReferenceElement.getReferenceName();
        return name == null ? 0 : name.hashCode();
    }
}

