/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeAugmenter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;

class TypeDfaInstance
implements DfaInstance<TypeDfaState> {
    private final Instruction[] myFlow;
    private final Set<Instruction> myInteresting;
    private final Set<Instruction> myAcyclicInstructions;
    private final InferenceCache myCache;
    private final InitialTypeProvider myInitialTypeProvider;

    TypeDfaInstance(Instruction @NotNull [] flow, @NotNull Couple<Set<Instruction>> interesting, @NotNull InferenceCache cache2, @NotNull InitialTypeProvider initialTypeProvider) {
        this.myFlow = flow;
        this.myInteresting = (Set)interesting.first;
        this.myAcyclicInstructions = (Set)interesting.second;
        this.myCache = cache2;
        this.myInitialTypeProvider = initialTypeProvider;
    }

    @Override
    public void fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        if (instruction instanceof ReadWriteVariableInstruction) {
            this.handleReadWriteVariable(state, (ReadWriteVariableInstruction)instruction);
        } else if (instruction instanceof MixinTypeInstruction) {
            this.handleMixin(state, (MixinTypeInstruction)instruction);
        } else if (instruction instanceof ArgumentsInstruction) {
            this.handleArguments(state, (ArgumentsInstruction)instruction);
        } else if (instruction instanceof NegatingGotoInstruction) {
            TypeDfaInstance.handleNegation(state, (NegatingGotoInstruction)instruction);
        }
    }

    private void handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
        VariableDescriptor descriptor = instruction.getVariableDescriptor();
        if (descriptor == null) {
            return;
        }
        this.updateVariableType(state, instruction, descriptor, (Computable<? extends DFAType>)((Computable)() -> {
            ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow);
            assert (originalInstr != null && !originalInstr.isWrite());
            DFAType original = state.getOrCreateVariableType(descriptor);
            original.addMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
            return original;
        }));
    }

    private void handleReadWriteVariable(@NotNull TypeDfaState state, @NotNull ReadWriteVariableInstruction instruction) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            return;
        }
        VariableDescriptor descriptor = instruction.getDescriptor();
        if (instruction.isWrite()) {
            this.updateVariableType(state, instruction, descriptor, (Computable<? extends DFAType>)((Computable)() -> {
                PsiType initializerType = TypeInferenceHelper.getInitializerType(element);
                if (initializerType == null && descriptor instanceof ResolvedVariableDescriptor) {
                    GrVariable variable = ((ResolvedVariableDescriptor)descriptor).getVariable();
                    PsiType augmentedType = TypeAugmenter.Companion.inferAugmentedType(variable);
                    return DFAType.create(augmentedType);
                }
                return DFAType.create(initializerType);
            }));
        } else {
            PsiType initialType;
            DFAType type2 = state.getVariableType(descriptor);
            if (type2 == null && (initialType = this.myInitialTypeProvider.initialType(descriptor)) != null) {
                this.updateVariableType(state, instruction, descriptor, (Computable<? extends DFAType>)((Computable)() -> DFAType.create(initialType)));
            }
        }
    }

    private void handleArguments(TypeDfaState state, ArgumentsInstruction instruction) {
        for (Map.Entry<VariableDescriptor, Collection<Argument>> entry : instruction.getArguments().entrySet()) {
            VariableDescriptor descriptor = entry.getKey();
            Collection<Argument> arguments2 = entry.getValue();
            this.handleArgument(state, instruction, descriptor, arguments2);
        }
    }

    private void handleArgument(TypeDfaState state, ArgumentsInstruction instruction, VariableDescriptor descriptor, Collection<Argument> arguments2) {
        this.updateVariableType(state, instruction, descriptor, (Computable<? extends DFAType>)((Computable)() -> {
            GroovyResolveResult[] results;
            DFAType result2 = state.getOrCreateVariableType(descriptor);
            for (GroovyResolveResult variant : results = instruction.getElement().multiResolve(false)) {
                ArgumentMapping<PsiCallParameter> mapping2;
                GroovyMethodCandidate candidate;
                if (!(variant instanceof GroovyMethodResult) || (candidate = ((GroovyMethodResult)variant).getCandidate()) == null || (mapping2 = candidate.getArgumentMapping()) == null) continue;
                for (Argument argument : arguments2) {
                    PsiType parameterType = mapping2.expectedType(argument);
                    if (parameterType == null) continue;
                    PsiType typeToMixin = variant.getSubstitutor().substitute(parameterType);
                    result2.addMixin(typeToMixin, null);
                }
            }
            return result2;
        }));
    }

    private void updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor, @NotNull Computable<? extends DFAType> computation) {
        if (!this.myInteresting.contains(instruction)) {
            state.removeBinding(descriptor);
            return;
        }
        DFAType type2 = this.myCache.getCachedInferredType(descriptor, instruction);
        if (type2 == null) {
            type2 = this.myAcyclicInstructions.contains(instruction) ? (DFAType)computation.compute() : TypeInferenceHelper.doInference(state.getBindings(), computation);
        }
        state.putType(descriptor, type2);
    }

    private static void handleNegation(@NotNull TypeDfaState state, @NotNull NegatingGotoInstruction negation) {
        for (Map.Entry<VariableDescriptor, DFAType> entry : state.getVarTypes().entrySet()) {
            entry.setValue(entry.getValue().negate(negation));
        }
    }
}

