/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;

public class NamedArgumentInsertHandler
implements InsertHandler<LookupElement> {
    public static final NamedArgumentInsertHandler INSTANCE = new NamedArgumentInsertHandler();

    private NamedArgumentInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        PsiElement argumentList;
        int tailOffset = context.getTailOffset();
        for (argumentList = context.getFile().findElementAt(tailOffset - 1); argumentList != null && !(argumentList instanceof GrArgumentList) && !(argumentList instanceof GrListOrMap); argumentList = argumentList.getParent()) {
        }
        Editor editor = context.getEditor();
        if (argumentList != null) {
            CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)context.getFile());
            GroovyCodeStyleSettings codeStyleSettings = (GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class);
            CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)GroovyLanguage.INSTANCE);
            boolean insertSpace = codeStyleSettings.SPACE_IN_NAMED_ARGUMENT;
            if (context.getCompletionChar() == ':' || insertSpace && context.getCompletionChar() == ' ') {
                context.setAddCompletionChar(false);
            }
            String argumentListText = argumentList.getText();
            String s = argumentListText.substring(tailOffset - argumentList.getTextOffset());
            if ((s = StringUtil.trimEnd((String)s, (String)")")).trim().isEmpty()) {
                String toInsert = insertSpace ? ": " : ":";
                editor.getDocument().insertString(tailOffset, (CharSequence)toInsert);
                editor.getCaretModel().moveToOffset(tailOffset + toInsert.length());
            } else {
                char a;
                if (context.getCompletionChar() == '\t' && Character.isLetterOrDigit(a = s.charAt(0))) {
                    return;
                }
                Matcher m = Pattern.compile("([ \\t]*):([ \\t]*)(.*)", 32).matcher(s);
                if (m.matches()) {
                    int caret = tailOffset + m.end(2);
                    if (m.group(2).isEmpty()) {
                        editor.getDocument().insertString(caret, (CharSequence)" ");
                        ++caret;
                    }
                    editor.getCaretModel().moveToOffset(caret);
                } else {
                    m = Pattern.compile("([ \\t]*)([\\n \\t]*)[\\],](.*)", 32).matcher(s);
                    if (m.matches()) {
                        String toInsert = insertSpace ? ": " : ":";
                        editor.getDocument().replaceString(tailOffset, tailOffset + m.start(2), (CharSequence)toInsert);
                        editor.getCaretModel().moveToOffset(tailOffset + toInsert.length());
                    } else {
                        m = Pattern.compile("([ \\t]*)(.*)", 32).matcher(s);
                        if (!m.matches()) {
                            throw new RuntimeException("This pattern must match any non-empty string! (" + s + ")");
                        }
                        StringBuilder sb = new StringBuilder(3);
                        sb.append(':');
                        int shiftCaret = 1;
                        if (insertSpace) {
                            sb.append(' ');
                            ++shiftCaret;
                        }
                        if (!m.group(2).startsWith("\n") && commonCodeStyleSettings.SPACE_AFTER_COMMA) {
                            sb.append(' ');
                        }
                        editor.getDocument().replaceString(tailOffset, tailOffset + m.start(2), (CharSequence)sb);
                        editor.getCaretModel().moveToOffset(tailOffset + shiftCaret);
                    }
                }
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
    }
}

