/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GroovyMethodOverrideHandler
implements InsertHandler<LookupElement> {
    private final PsiClass myPsiClass;

    public GroovyMethodOverrideHandler(PsiClass aClass) {
        this.myPsiClass = aClass;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
        PsiMethod method = (PsiMethod)item.getObject();
        List prototypes = OverrideImplementUtil.overrideOrImplementMethod((PsiClass)this.myPsiClass, (PsiMethod)method, (boolean)false);
        context.commitDocument();
        GenerateMembersUtil.insertMembersAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), (List)OverrideImplementUtil.convert2GenerationInfos((Collection)prototypes));
    }
}

