/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.InferMethodParametersTypesIntention;
import org.jetbrains.plugins.groovy.intentions.style.inference.DefaultInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "collectParameterSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteMethodSignature", "sourceMethod", "sinkMethod", "intellij.groovy"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        }
        GrMethod method = (GrMethod)psiElement;
        SignatureInferenceOptions options2 = new SignatureInferenceOptions((SearchScope)GlobalSearchScope.allScope((Project)project), false, DefaultInferenceContext.INSTANCE, (Lazy<? extends List<? extends PsiReference>>)LazyKt.lazy((Function0)processIntention.options.1.INSTANCE));
        GrMethod virtualMethod = InferenceProcessKt.runInferenceProcess(method, options2);
        this.substituteMethodSignature(virtualMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    private final void substituteMethodSignature(GrMethod sourceMethod, GrMethod sinkMethod) {
        block24: {
            Object object;
            block26: {
                block25: {
                    PsiAnnotation[] it;
                    if (!sinkMethod.isConstructor() && !sinkMethod.getModifierList().hasModifierProperty("def")) {
                        sinkMethod.getModifierList().setModifierProperty("def", true);
                    }
                    if (sourceMethod.hasTypeParameters()) {
                        if (sinkMethod.hasTypeParameters()) {
                            PsiTypeParameterList psiTypeParameterList = sinkMethod.getTypeParameterList();
                            if (psiTypeParameterList == null) {
                                Intrinsics.throwNpe();
                            }
                            PsiTypeParameterList psiTypeParameterList2 = sourceMethod.getTypeParameterList();
                            if (psiTypeParameterList2 == null) {
                                Intrinsics.throwNpe();
                            }
                            psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
                        } else if (sinkMethod.isConstructor()) {
                            PsiSubstitutor parameterSubstitutor = this.collectParameterSubstitutor(sourceMethod);
                            GrParameter[] $this$forEach$iv = sourceMethod.getParameters();
                            boolean $i$f$forEach = false;
                            GrParameter[] grParameterArray = $this$forEach$iv;
                            int n = grParameterArray.length;
                            for (int i = 0; i < n; ++i) {
                                PsiAnnotation[] element$iv;
                                it = element$iv = grParameterArray[i];
                                boolean bl = false;
                                it.setType(InferenceProcessUtilKt.recursiveSubstitute$default(parameterSubstitutor, it.getType(), 0, 2, null));
                            }
                        } else {
                            PsiTypeParameterList psiTypeParameterList = sourceMethod.getTypeParameterList();
                            if (psiTypeParameterList == null) {
                                Intrinsics.throwNpe();
                            }
                            sinkMethod.addAfter((PsiElement)psiTypeParameterList, sinkMethod.getFirstChild());
                        }
                    }
                    for (PsiSubstitutor parameterSubstitutor : ArraysKt.zip((Object[])sinkMethod.getParameters(), (Object[])sourceMethod.getParameters())) {
                        PsiAnnotation[] $this$mapTo$iv$iv;
                        void actual;
                        GrParameter $i$f$forEach = (GrParameter)parameterSubstitutor.component1();
                        GrParameter inferred = (GrParameter)parameterSubstitutor.component2();
                        actual.setType(inferred.getType());
                        actual.getModifierList().setModifierProperty("def", false);
                        if (actual.isVarArgs()) {
                            PsiElement psiElement = actual.getEllipsisDots();
                            if (psiElement == null) {
                                Intrinsics.throwNpe();
                            }
                            psiElement.delete();
                        }
                        PsiAnnotation[] $this$map$iv = actual.getAnnotations();
                        boolean $i$f$map = false;
                        it = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        void var13_27 = $this$mapTo$iv$iv;
                        int n = ((void)var13_27).length;
                        for (int i = 0; i < n; ++i) {
                            void it2;
                            void item$iv$iv;
                            void var17_32 = item$iv$iv = var13_27[i];
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it2.getText();
                            collection.add(string);
                        }
                        List currentAnnotations = (List)destination$iv$iv;
                        PsiAnnotation[] $this$forEach$iv = inferred.getAnnotations();
                        boolean $i$f$forEach2 = false;
                        $this$mapTo$iv$iv = $this$forEach$iv;
                        int n2 = $this$mapTo$iv$iv.length;
                        for (int i = 0; i < n2; ++i) {
                            PsiAnnotation anno;
                            PsiAnnotation element$iv;
                            PsiAnnotation it3 = element$iv = $this$mapTo$iv$iv[i];
                            boolean bl = false;
                            if (currentAnnotations.contains(it3.getText())) continue;
                            GrModifierList grModifierList = actual.getModifierList();
                            String string = it3.getText();
                            int n3 = 1;
                            boolean bl2 = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                            PsiAnnotation psiAnnotation = anno = grModifierList.addAnnotation(string3);
                            if (psiAnnotation == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation");
                            }
                            PsiElement psiElement = ((GrAnnotation)psiAnnotation).getOriginalElement();
                            if (psiElement == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement");
                            }
                            GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiElement);
                            PsiAnnotationMemberValue psiAnnotationMemberValue = anno.findAttributeValue("value");
                            Object object2 = psiAnnotationMemberValue != null ? psiAnnotationMemberValue.getReference() : null;
                            if (!(object2 instanceof GrQualifiedReference)) {
                                object2 = null;
                            }
                            GrQualifiedReference grQualifiedReference = (GrQualifiedReference)object2;
                            if (grQualifiedReference == null) {
                                continue;
                            }
                            GrReferenceAdjuster.shortenReference(grQualifiedReference);
                        }
                    }
                    PsiTypeParameter[] $this$forEach$iv = sinkMethod.getTypeParameters();
                    boolean $i$f$forEach = false;
                    PsiTypeParameter[] psiTypeParameterArray = $this$forEach$iv;
                    int n = psiTypeParameterArray.length;
                    for (int currentAnnotations = 0; currentAnnotations < n; ++currentAnnotations) {
                        PsiTypeParameter element$iv;
                        PsiTypeParameter it4 = element$iv = psiTypeParameterArray[currentAnnotations];
                        boolean bl = false;
                        GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)it4.getOriginalElement());
                    }
                    if (sinkMethod.isConstructor() || sinkMethod.getReturnTypeElement() != null) break block24;
                    object = sinkMethod.getInferredReturnType();
                    if (object == null) break block25;
                    PsiType psiType = object;
                    boolean bl = false;
                    n = 0;
                    PsiType it5 = psiType;
                    boolean bl3 = false;
                    object = Intrinsics.areEqual((Object)it5, (Object)PsiType.NULL) ^ true ? psiType : null;
                    if (object != null) break block26;
                }
                object = (PsiType)InferenceDriverUtilKt.getJavaLangObject(sinkMethod);
            }
            PsiType returnType2 = object;
            GrReferenceAdjuster.shortenAllReferencesIn(sinkMethod.setReturnType(returnType2));
        }
        sinkMethod.getModifierList().setModifierProperty("def", false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiSubstitutor collectParameterSubstitutor(GrMethod virtualMethod) {
        void $this$mapTo$iv$iv;
        PsiTypeParameter[] $this$map$iv = virtualMethod.getTypeParameters();
        boolean $i$f$map = false;
        PsiTypeParameter[] psiTypeParameterArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])it.getExtendsListTypes());
            if (psiClassType == null) {
                psiClassType = InferenceDriverUtilKt.getJavaLangObject(virtualMethod);
            }
            PsiClassType psiClassType2 = psiClassType;
            collection.add(psiClassType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClassType[] psiClassTypeArray = thisCollection$iv.toArray(new PsiClassType[0]);
        if (psiClassTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return InferenceKt.putAll(PsiSubstitutor.EMPTY, virtualMethod.getTypeParameters(), (PsiType[])psiClassTypeArray);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return getElementPredicate.1.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyIntentionsBundle.message("infer.method.parameters.types", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyIntentionsBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
    }
}

