/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertToGeeseBracesIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertToGeeseBracesIntention.class);
    private static final PsiElementPredicate MY_PREDICATE = new PsiElementPredicate(){

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            if (!((GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)element.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class)).USE_FLYING_GEESE_BRACES) {
                return false;
            }
            if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
                element = PsiTreeUtil.prevLeaf((PsiElement)element);
            }
            if (!GeeseUtil.isClosureRBrace(element) || !GeeseUtil.isClosureContainLF(element)) {
                return false;
            }
            TextRange range = ConvertToGeeseBracesIntention.findRange(element);
            return StringUtil.contains((CharSequence)element.getContainingFile().getText(), (int)range.getStartOffset(), (int)range.getEndOffset(), (char)'\n');
        }
    };

    @Nullable
    private static PsiElement getPrev(PsiElement element) {
        PsiElement prev = PsiUtil.getPreviousNonWhitespaceToken(element);
        if (prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            prev = PsiUtil.getPreviousNonWhitespaceToken(prev);
        }
        return prev;
    }

    @Nullable
    private static PsiElement getNext(PsiElement element) {
        PsiElement next = GeeseUtil.getNextNonWhitespaceToken(element);
        if (next != null && next.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            next = GeeseUtil.getNextNonWhitespaceToken(next);
        }
        return next;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        LOG.assertTrue(GeeseUtil.isClosureRBrace(element) && GeeseUtil.isClosureContainLF(element));
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        TextRange textRange = ConvertToGeeseBracesIntention.findRange(element);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        RangeMarker rangeMarker = document.createRangeMarker(textRange);
        String text = document.getText();
        for (int i = endOffset - 1; i >= startOffset; --i) {
            if (text.charAt(i) != '\n') continue;
            document.deleteString(i, i + 1);
        }
        CodeStyleManager.getInstance((Project)project).reformatText(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
    }

    private static TextRange findRange(PsiElement element) {
        PsiElement first = null;
        PsiElement last = null;
        PsiElement cur = element;
        while (GeeseUtil.isClosureRBrace(cur) && GeeseUtil.isClosureContainLF(cur)) {
            last = cur;
            cur = ConvertToGeeseBracesIntention.getNext(cur);
        }
        cur = element;
        while (GeeseUtil.isClosureRBrace(cur) && GeeseUtil.isClosureContainLF(cur)) {
            first = cur;
            cur = ConvertToGeeseBracesIntention.getPrev(cur);
        }
        LOG.assertTrue(first != null);
        LOG.assertTrue(last != null);
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return MY_PREDICATE;
    }
}

