/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import kotlin.Metadata;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.highlighter.GroovyKeywordAnnotatorKt;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.highlighter.UtilKt;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a8\u0006\t"}, d2={"getDeclarationHighlightingAttribute", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "declaration", "Lcom/intellij/psi/PsiElement;", "getElementAttribute", "element", "getReferenceHighlightingAttribute", "reference", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "intellij.groovy.psi"})
public final class DeclarationsKt {
    private static final TextAttributesKey getElementAttribute(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof GrAnnotation && element.getNode().getElementType() == GroovyTokenTypes.mAT) {
            return GroovySyntaxHighlighter.ANNOTATION;
        }
        if (parent2 instanceof GrAnnotationNameValuePair && ((GrAnnotationNameValuePair)parent2).getNameIdentifierGroovy() == element) {
            return GroovySyntaxHighlighter.ANNOTATION_ATTRIBUTE_NAME;
        }
        return null;
    }

    private static final TextAttributesKey getReferenceHighlightingAttribute(GrReferenceElement<?> reference) {
        TextAttributesKey textAttributesKey;
        if (UtilKt.isReferenceWithLiteralName(reference)) {
            return null;
        }
        if (UtilKt.isAnonymousClassReference(reference)) {
            return null;
        }
        GroovyResolveResult resolveResult2 = reference.advancedResolve();
        PsiElement psiElement = resolveResult2.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolved = psiElement;
        PsiElement nameElement = reference.getReferenceNameElement();
        if (nameElement != null && UtilKt.isThisOrSuper(nameElement)) {
            if (resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            if (resolved instanceof PsiClass) {
                return GroovyKeywordAnnotatorKt.shouldBeErased(nameElement) ? GroovySyntaxHighlighter.KEYWORD : null;
            }
        }
        if (resolved instanceof PsiMethod) {
            if (((PsiMethod)resolved).isConstructor()) {
                textAttributesKey = GroovySyntaxHighlighter.CONSTRUCTOR_CALL;
            } else {
                boolean isStatic = ((PsiMethod)resolved).hasModifierProperty("static");
                textAttributesKey = resolveResult2.isInvokedOnProperty() ? (isStatic ? GroovySyntaxHighlighter.STATIC_PROPERTY_REFERENCE : GroovySyntaxHighlighter.INSTANCE_PROPERTY_REFERENCE) : (isStatic ? GroovySyntaxHighlighter.STATIC_METHOD_ACCESS : GroovySyntaxHighlighter.METHOD_CALL);
            }
        } else {
            textAttributesKey = DeclarationsKt.getDeclarationHighlightingAttribute(resolved);
        }
        return textAttributesKey;
    }

    private static final TextAttributesKey getDeclarationHighlightingAttribute(PsiElement declaration) {
        Object object;
        PsiElement psiElement = declaration;
        if (psiElement instanceof GrLabeledStatement) {
            object = GroovySyntaxHighlighter.LABEL;
        } else if (psiElement instanceof PsiTypeParameter) {
            object = GroovySyntaxHighlighter.TYPE_PARAMETER;
        } else if (psiElement instanceof PsiMethod) {
            object = ((PsiMethod)declaration).isConstructor() ? GroovySyntaxHighlighter.CONSTRUCTOR_DECLARATION : (UtilKt.isMethodWithLiteralName((PsiMethod)declaration) ? null : GroovySyntaxHighlighter.METHOD_DECLARATION);
        } else if (psiElement instanceof PsiClass) {
            object = declaration instanceof GrTraitTypeDefinition ? GroovySyntaxHighlighter.TRAIT_NAME : (declaration instanceof GrAnonymousClassDefinition ? GroovySyntaxHighlighter.ANONYMOUS_CLASS_NAME : (((PsiClass)declaration).isAnnotationType() ? GroovySyntaxHighlighter.ANNOTATION : (((PsiClass)declaration).isInterface() ? GroovySyntaxHighlighter.INTERFACE_NAME : (((PsiClass)declaration).isEnum() ? GroovySyntaxHighlighter.ENUM_NAME : GroovySyntaxHighlighter.CLASS_REFERENCE))));
        } else if (psiElement instanceof PsiField) {
            object = ((PsiField)declaration).hasModifierProperty("static") ? GroovySyntaxHighlighter.STATIC_FIELD : GroovySyntaxHighlighter.INSTANCE_FIELD;
        } else if (psiElement instanceof GrParameter) {
            object = GrHighlightUtil.isReassigned((GrVariable)declaration) ? GroovySyntaxHighlighter.REASSIGNED_PARAMETER : GroovySyntaxHighlighter.PARAMETER;
        } else if (psiElement instanceof GrVariable) {
            object = ResolveUtil.isScriptField((GrVariable)declaration) ? (((GrVariable)declaration).hasModifierProperty("static") ? GroovySyntaxHighlighter.STATIC_FIELD : GroovySyntaxHighlighter.INSTANCE_FIELD) : (GrHighlightUtil.isReassigned((GrVariable)declaration) ? GroovySyntaxHighlighter.REASSIGNED_LOCAL_VARIABLE : GroovySyntaxHighlighter.LOCAL_VARIABLE);
        } else {
            return null;
        }
        return object;
    }

    public static final /* synthetic */ TextAttributesKey access$getReferenceHighlightingAttribute(GrReferenceElement reference) {
        return DeclarationsKt.getReferenceHighlightingAttribute(reference);
    }

    public static final /* synthetic */ TextAttributesKey access$getDeclarationHighlightingAttribute(PsiElement declaration) {
        return DeclarationsKt.getDeclarationHighlightingAttribute(declaration);
    }

    public static final /* synthetic */ TextAttributesKey access$getElementAttribute(PsiElement element) {
        return DeclarationsKt.getElementAttribute(element);
    }
}

